unit UTriangle;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
  const c : array[1..15] of TColor
                         = (clBlack,  // F
                            clMaroon, // IF
                            clGreen,  // ΐF
                            clOlive,  // ΐF
                            clNavy,   // ZF
                            clPurple, // F
                            clTeal,   // ÐΐF
                            clGray,   // DF
                            clSilver, // F
                            clRed,    // ԐF
                            clLime,   // ZΐF
                            clBlue,   // F
                            clFuchsia,// ԎF
                            clAqua,   // F
                            clWhite); // F
  var  AX,AY,BX,BY,CX,CY : real;


  procedure  Draw_Triangle( AX, AY, BX, BY, CX, CY : real;
                            n : integer );
    begin
         if n < 16 then
           with canvas do
             begin
               Pen.Color:=c[n];
               Brush.Color:=c[n];
               Polygon([Point(round(AX),round(AY)),
                        Point(round(BX),round(BY)),
                        Point(round(CX),round(CY))]);
               Draw_Triangle(0.9*AX+0.1*BX, 0.9*AY+0.1*BY,
                             0.9*BX+0.1*CX, 0.9*BY+0.1*CY,
                             0.9*CX+0.1*AX, 0.9*CY+0.1*AY,
                             n+1 );
             end;
    end;   {   Draw_Triangle   }

begin
     Button1.Visible:=False;
     with Canvas do
       begin
            Pen.Color:=clWhite;
            Brush.Color:=clWhite;
            Rectangle(0,0,ClientWidth,ClientHeight);

            with Font do
              begin Size:=20; Color:=clBlue; end;
            TextOut(30,30,'F萔');

            AX:=ClientWidth*0.05;
            AY:=ClientHeight*0.95;
            BX:=ClientWidth*0.5;
            BY:=ClientHeight*0.05;
            CX:=ClientWidth*0.95;
            CY:=ClientHeight*0.95;

            Draw_Triangle(AX,AY,BX,BY,CX,CY,1);
       end;
end;

end.
