unit CompRN;

interface

uses     Classes;  //  TComponentƎ葱RegisterComponents̎gp̂

type     Real = Extended;

type     TUniRandom   = class(TComponent)
                                s1, s2, s3 : integer;

                                procedure  InitRN(i1, i2, i3 : integer);
                                                    virtual;
                                procedure  InitRN0; virtual;
                                function   unirandom : real;

                                constructor Create(AOwner : TComponent);
                                                    override;
                                function   GetSeed1 : integer;
                                procedure  SetSeed1( ASeed1 : integer );
                                function   GetSeed2 : integer;
                                procedure  SetSeed2( ASeed2 : integer );
                                function   GetSeed3 : integer;
                                procedure  SetSeed3( ASeed3 : integer );
                         published
                                property   Seed1 : integer
                                           read    GetSeed1
                                           write   SetSeed1;
                                property   Seed2 : integer
                                           read    GetSeed2
                                           write   SetSeed2;
                                property   Seed3 : integer
                                           read    GetSeed3
                                           write   SetSeed3;
                         end;

         TNormalRN =    class(TUniRandom)
                                 procedure InitRN(i1, i2, i3 : integer);
                                                    override;
                                 procedure InitRN0; override;
                                 procedure Normals( var n1, n2 : real );
                         end;

procedure  Register;


implementation


procedure  Register;
  begin
        RegisterComponents('MyComp', [TUniRandom,TNormalRN]);
  end;


constructor TUniRandom.Create( AOwner : TComponent );
  begin
        inherited;
        s1:=1;  s2:=1;  s3:=1;
  end;


function  TUniRandom.GetSeed1 : integer;
  begin
          Result:=s1;
  end;

procedure TUniRandom.SetSeed1( ASeed1 : integer );
  begin
            s1:=ASeed1;
            if (0 > s1) or (s1 > 30000) then s1:=1;
  end;


function  TUniRandom.GetSeed2 : integer;
  begin
          Result:=s2;
  end;

procedure TUniRandom.SetSeed2( ASeed2 : integer );
  begin
            s2:=ASeed2;
            if (0 > s2) or (s2 > 30000) then s2:=1;
  end;


function  TUniRandom.GetSeed3 : integer;
  begin
          Result:=s3;
  end;

procedure TUniRandom.SetSeed3( ASeed3 : integer );
  begin
            s3:=ASeed3;
            if (0 > s3) or (s3 > 30000) then s3:=1;
  end;


procedure  TUniRandom.InitRN( i1, i2, i3 : integer );
  begin
        if (0 < i1) and (i1 < 30000) then s1:=i1 else s1:=1;
        if (0 < i2) and (i2 < 30000) then s2:=i2 else s2:=1;
        if (0 < i3) and (i3 < 30000) then s3:=i3 else s3:=1;
  end;


procedure  TUniRandom.InitRN0;
  begin
              InitRN( 1, 1, 1 );
  end;


function  TUniRandom.unirandom : real;
  begin
        s1:=171*(s1 mod 177)-2*(s1 div 177);
        s2:=172*(s2 mod 176)-35*(s2 div 176);
        s3:=170*(s3 mod 178)-63*(s3 div 178);

        if s1 < 0 then s1:=s1+30269;
        if s2 < 0 then s2:=s2+30307;
        if s3 < 0 then s3:=s3+30323;

        unirandom:=frac(s1/30269+s2/30307+s3/30323);
  end;


procedure  TNormalRN.InitRN(i1, i2, i3 : integer);
  begin
           Inherited InitRN(i1, i2, i3);
  end;


procedure  TNormalRN.InitRN0;
  begin
           InitRN( 1, 1, 1 );
  end;


procedure  TNormalRN.Normals( var n1, n2 : real );
  var  y1, p_y : real;
  begin
         repeat
                y1:=unirandom;
         until  y1 > 0.0;
         y1:=sqrt(-2*ln(y1));

         p_y:=2*pi*unirandom;

         n1:=y1*cos(p_y);
         n2:=y1*sin(p_y);
  end;

end.
