unit UWalk;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, CompRN;

type
  TForm1 = class(TForm)
    StartButton: TButton;
    StopButton: TButton;
    Timer1: TTimer;
    N_RN: TNormalRN;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


type  real = extended;

const c : array[1..6] of TColor
                      =  (clRed,   clOlive,
                          clGreen, clBlue,
                          clPurple,clBlack );

var   x, y : array[1..7] of real;


procedure TForm1.FormActivate(Sender: TObject);
var  i : integer;
     n1, n2 : real;
begin
     Timer1.Enabled:=False;
     with N_RN do
       ShowMessage('s1 = '+IntToStr(Seed1)+
                   '      s2 = '+IntToStr(Seed2)+
                   '      s3 = '+IntToStr(Seed3));

     Timer1.Enabled:=True;
     Timer1.Interval:=200;

     Color:=clWHite;
     with Canvas do
       begin
         x[7]:=ClientWidth/2;
         y[7]:=ClientHeight/2;
         MoveTo(round(x[7]), round(y[7]));
         for i:=6 downto 1 do
           begin
             N_RN.Normals(n1, n2);
             x[i]:=x[i+1]+n1*5;
             y[i]:=y[i+1]+n2*5;
             Pen.Color:=c[i];
             LineTo(round(x[i]), round(y[i]));
           end;
       end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var  i : integer;
     nx, ny : real;
begin
     with Canvas do
       begin
         MoveTo(round(x[6]), round(y[6]));
         for i:=6 downto 2 do
           begin
             Pen.Color:=c[i];
             LineTo(round(x[i-1]), round(y[i-1]));
             x[i+1]:=x[i];  y[i+1]:=y[i];
           end;

         x[2]:=x[1];  y[2]:=y[1];
         N_RN.Normals(nx, ny);
         x[1]:=x[1]+nx*5;
         y[1]:=y[1]+ny*5;
         Pen.Color:=c[1];
         LineTo(round(x[1]), round(y[1]));  
       end;
end;

procedure TForm1.StartButtonClick(Sender: TObject);
begin
           Timer1.Enabled:=True;
end;

procedure TForm1.StopButtonClick(Sender: TObject);
begin
           Timer1.Enabled:=False;
end;

end.
