unit UMean;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.OKButtonClick(Sender: TObject);
  var      mean, s, v, sd, u_v, u_sd, c : real;
           n, i  : integer;
           x  : array[1..1000] of real;
           in_f, out_f  : TextFile;
           in_nm, out_nm : string;
begin
     MsgLabel.Caption:='vZł'; UpDate;

     in_nm:=InFileNmEdit.Text;
     AssignFile(in_f, in_nm); reset(in_f);
     out_nm:=OutFileNmEdit.Text;
     AssignFile(out_f, out_nm);  rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', in_nm);

     readln(in_f, c);  n := 0;
     repeat
       n := n + 1;     readln(in_f, x[n]);
     until  x[n] <= c ;
     CloseFile(in_f);   n := n - 1;

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, 'x[', i, '] = ', x[i]:9:2);

     s := 0.0;
     for i := 1 to n do  s := s + x[i];
     mean := s / n ;

     s := 0.0;
     for i := 1 to n do
       s := s + sqr( mean - x[i] );
     v  := s / n ;
     sd := sqrt( v );
     u_v  := s / (n-1);
     u_sd := sqrt(u_v);

     writeln(out_f);
     writeln(out_f);
     writeln(out_f, 'ϒl         =', mean:15:5);
     writeln(out_f);
     writeln(out_f, 'W΍(s) =', u_sd:15:5);
     writeln(out_f);
     writeln(out_f, 'U(s)     =', u_v :15:5);
     writeln(out_f);
     writeln(out_f, 'W΍       =', sd  :15:5);
     writeln(out_f);
     writeln(out_f, 'U           =', v   :15:5);

     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

end.
