unit UMedianQS;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type  Vector = array[1..180000] of real;

procedure  QuickSort( var x : Vector;
                          n : integer );

  procedure  Sort( L, r : integer );
    var  i, j : integer;
         c, t : real;
    begin
         i:=L; j:=r;
         c:=x[(L+r) div 2];
         repeat
              while x[i] < c do i:=i+1;
              while x[j] > c do j:=j-1;
              if i <= j then
                begin
                    t:=x[i]; x[i]:=x[j]; x[j]:=t;
                    i:=i+1; j:=j-1;
                end;
         until  i > j;

         if L < j then Sort( L, j );
         if i < r then Sort( i, r );
    end;   {   Sort   }

  begin  {   QuickSort   }

           Sort( 1, n );
             
  end;   {   QuickSort   }


procedure TForm1.OKButtonClick(Sender: TObject);
  var      c, min_x, max_x, median, q1, q3 : real;
           n, i : integer;
           x  :  Vector;
           in_f, out_f  : TextFile;
           in_nm, out_nm : string;


  procedure  calc_quartile( var  q1, q3 : real );
    var      i, j : integer;
             w1, w2, v1, v2 : real;
    begin
      i:=trunc( 0.5 + n/4 );
      if abs( 0.5 + n/4 - i ) < 0.1
        then  q1 := x[i]
        else
            begin
              w1 := 0.5 + n/4 - i;  w2 := i + 1 - 0.5 - n/4;
              q1 := w2 * x[i] + w1 * x[i+1];
            end;

      j := trunc( 0.5 + 3*n/4 );
      if abs( 0.5 + 3*n/4 - j ) < 0.1
        then  q3 := x[j]
        else
            begin
              v1 := 0.5 + 3*n/4 - j;  v2 := j + 1 - 0.5 - 3*n/4;
              q3 := v2 * x[j] + v1 * x[j+1];
            end;
    end;


begin
     MsgLabel.Caption:='vZł'; UpDate;

     in_nm:=InFileNmEdit.Text;
     AssignFile(in_f, in_nm); reset(in_f);
     out_nm:=OutFileNmEdit.Text;
     AssignFile(out_f, out_nm);  rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', in_nm);

     readln(in_f, c);  n := 0;
     repeat
       n := n + 1;     readln(in_f, x[n]);
     until  x[n] <= c ;
     CloseFile(in_f);   n := n - 1;

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, 'x[', i, '] = ', x[i]:9:2);


     QuickSort( x, n );

     writeln(out_f);
     writeln(out_f, 'ׂ̃f[^...');
     for i:=1 to n do
       writeln(out_f, 'x[', i, '] = ', x[i]:9:2);

     min_x := x[1];  max_x := x[n];

     if odd(n)  then median := x[ (n div 2) + 1 ]
                else median := 0.5 * (x[n div 2] + x[(n div 2) + 1]);

     calc_quartile( q1, q3 );

     writeln(out_f);
     writeln(out_f);
     writeln(out_f, 'ŏl =', min_x :15:5);
     writeln(out_f);
     writeln(out_f, 'Q1     =', q1    :15:5);
     writeln(out_f);
     writeln(out_f, 'l =', median:15:5);
     writeln(out_f);
     writeln(out_f, 'Q3     =', q3    :15:5);
     writeln(out_f);
     writeln(out_f, 'ől =', max_x :15:5);

     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

end.
