unit UPearsonCorr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$R+}

procedure TForm1.OKButtonClick(Sender: TObject);
  var      c, s_x, s_xx, s_y, s_yy, s_xy,
           mean_x, v_x, sd_x, u_v_x, u_sd_x,
           mean_y, v_y, sd_y, u_v_y, u_sd_y,
           r  : real;
           n, i  : integer;
           x, y  : array[1..1000] of real;
           in_f, out_f  : TextFile;
           in_nm, out_nm : string;
begin
     MsgLabel.Caption:='vZł'; UpDate;

     in_nm:=InFileNmEdit.Text;
     AssignFile(in_f, in_nm); reset(in_f);
     out_nm:=OutFileNmEdit.Text;
     AssignFile(out_f, out_nm);  rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', in_nm);

     readln(in_f, c);  n := 0;
     repeat
          n:=n+1;
          read(in_f, x[n]);
          if x[n] > c then readln(in_f, y[n]);
     until  x[n] <= c ;
     CloseFile(in_f);
     n:=n-1;

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, '(x[', i, '], y[', i, ']) = (',
                      x[i]:9:2, ',', y[i]:9:2, ')' );

     s_x:=0.0; s_xx:=0.0; s_y:=0.0; s_yy:=0.0; s_xy:=0.0;
     for i:=1 to n do
       begin
           s_x:=s_x+x[i]; s_xx:=s_xx+sqr(x[i]);
           s_y:=s_y+y[i]; s_yy:=s_yy+sqr(y[i]);
           s_xy:=s_xy+x[i]*y[i];
       end;
     mean_x:=s_x/n;
     v_x:=(s_xx/n)-sqr(mean_x);
     sd_x:=sqrt(v_x);
     u_v_x:=v_x*n/(n-1);
     u_sd_x:=sqrt(u_v_x);
     mean_y:=s_y/n;
     v_y:=(s_yy/n)-sqr(mean_y);
     sd_y:=sqrt(v_y);
     u_v_y:=v_y*n/(n-1);
     u_sd_y:=sqrt(u_v_y);
     r:=(n*s_xy-s_x*s_y)/sqrt((n*s_xx-sqr(s_x))*(n*s_yy-sqr(s_y)));

     writeln(out_f);
     writeln(out_f, '-------------------------------------');
     writeln(out_f);
     writeln(out_f, 'ϒl(X)          = ', mean_x:15:5);
     writeln(out_f);
     writeln(out_f, 'W΍(s)(X)  = ', u_sd_x:15:5);
     writeln(out_f);
     writeln(out_f, 'U(s)(X)      = ', u_v_x:15:5);
     writeln(out_f);
     writeln(out_f, 'W΍(X)        = ', sd_x:15:5);
     writeln(out_f);
     writeln(out_f, 'U(X)            = ', v_x:15:5);
     writeln(out_f);
     writeln(out_f, '-------------------------------------');
     writeln(out_f);
     writeln(out_f, 'ϒl(Y)          = ', mean_y:15:5);
     writeln(out_f);
     writeln(out_f, 'W΍(s)(Y)  = ', u_sd_y:15:5);
     writeln(out_f);
     writeln(out_f, 'U(s)(Y)      = ', u_v_y:15:5);
     writeln(out_f);
     writeln(out_f, 'W΍(Y)        = ', sd_y:15:5);
     writeln(out_f);
     writeln(out_f, 'U(Y)            = ', v_y:15:5);
     writeln(out_f);
     writeln(out_f);
     writeln(out_f, '=====================================');
     writeln(out_f);
     writeln(out_f, '֌W           = ', r:15:5);

     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

end.
