unit UNewton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    ValueLabel: TLabel;
    ValueEdit: TEdit;
    RootLabel: TLabel;
    RootEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
        MsgLabel.Caption:='l(>0.0)ݒ肵ĉ';
        RootEdit.Text:='';
        ValueEdit.Text:='';
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;


type  func = function( x : real ) : real;

function  My_sqr( x : real ) : real;
  begin
           My_sqr:=sqr(x);
  end;

function  d_sqr( x : real ) : real;
  begin
            d_sqr:=2*x;
  end;


procedure Newton( var x : real;
                  c     : real;
                  f, df : func );
  var  x0 : real;
  begin
       repeat
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until  abs(x-x0) < ((1.0E-9)*(abs(x)+abs(x0)));
  end;   {   Newton   }

procedure TForm1.OKButtonClick(Sender: TObject);
var  c, root : real;
     s       : string;
begin
     MsgLabel.Caption:='vZł';
     c:=StrToFloat(ValueEdit.Text);
     root:=c;
     Newton( root, c, My_sqr, d_sqr );
     Str(root:15, s);
     RootEdit.Text:=s;
     MsgLabel.Caption:='vZI܂';
end;

end.
