unit USimpson;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ExitButton: TButton;
    MsgLabel: TLabel;
    OKButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
      MsgLabel.Caption:='nj{^ĉ';
      OKButton.SetFocus;   //  nj{^ɓ̓tH[JX
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
              Close;
end;


type    real = extended;
        func = function( x : real ) : real;

function f( x : real ) : real;
  begin
        f:=sqrt(1.0-sqr(x));
  end;


function Simpson( a, b : real;
                  f    : func ) : real;
  var  fa, fb, s_odd, s_even,
       Intgrl1, Intgrl2  : real;
       n  : Longint;


  procedure  init;
    var  h : real;
         j : Longint;
    begin
         n:=10;
         h:=(b-a)/(2*n);
         s_odd:=f(a+h*(2*n-1));
         s_even:=0.0;
         for j:=1 to n-1 do
           begin
               s_odd:=s_odd+f(a+h*(2*j-1));
               s_even:=s_even+f(a+h*2*j);
           end;
         fa:=f(a);  fb:=f(b);
         Intgrl1:=h*(fa+4*s_odd+2*s_even+fb)/3;
         n:=n*2;
    end;   {   init   }

  function  calc : real;
    var  h : real;
         j : Longint;
    begin
         h:=(b-a)/(2*n);
         s_even:=s_even+s_odd;
         s_odd:=0.0;
         for j:=1 to n do
           s_odd:=s_odd+f(a+h*(2*j-1));
         calc:=h*(fa+4*s_odd+2*s_even+fb)/3;
    end;   {   calc   }

  begin   {   Simpson   }
        init;
        repeat
             Intgrl2:=Intgrl1;
             Intgrl1:=calc;
             n:=n*2;
        until  (abs(Intgrl1-Intgrl2) < (abs(Intgrl2)*(1.0E-9)))
             or
               ((abs(Intgrl1)+abs(Intgrl2)) < (1.0E-9))
             or (n < 0);

         if n < 0 then
           begin
               ShowMessage('JԂI[o[(Simpson)');
               Application.Terminate;    //  vȌI
           end;

         Simpson:=Intgrl2;  
  end;   {   Simpson   }


procedure TForm1.OKButtonClick(Sender: TObject);
var   v : real;
      s : string;
begin
      MsgLabel.Caption:='vZł'; UpDate;
      v:=Simpson( -1.0, 1.0, f );
      Str( 2*v:10:7, s );
      MsgLabel.Caption:=' = '+s;
end;

end.
