unit UGauss;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ExitButton: TButton;
    MsgLabel: TLabel;
    OKButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
      MsgLabel.Caption:='nj{^ĉ';
      OKButton.SetFocus;   //  nj{^ɓ̓tH[JX
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
              Close;
end;


type    real = extended;
        func = function( x : real ) : real;

function f( x : real ) : real;
  begin
        f:=sqrt(1.0-sqr(x));
  end;


function  Gauss_Legendre( a, b : real;
                          f    : func ) : real;
  type   pos_arry = array[1..5] of real;
  const  x0 : pos_arry = (-0.906179845939,
                          -0.538469310106,
                           0.0,
                           0.538469310106,
                           0.906179845939);
         w  : pos_arry = ( 0.236926885056,
                           0.478628670499,
                           0.568888888889,
                           0.478628670499,
                           0.236926885056);
         accuracy = 1.0E-9;
  var    v0, v1, i_w, ia, ib, xi : real;
         n_div, step, i : longint;
  begin
         v1:=1.0E30;  n_div:=1;
         repeat
               v0:=v1;  v1:=0.0;
               i_w:=(b-a)/n_div;
               for step:=1 to n_div do
                 begin
                       ia:=a+(i_w*(step-1));
                       ib:=ia+i_w;
                       for i:=1 to 5 do
                         begin
                               xi:=(0.5*i_w*x0[i])+(0.5*(ib+ia));
                               v1:=v1+(w[i]*f(xi));
                         end;
                 end;
               v1:=0.5*i_w*v1;  n_div:=n_div*2;
         until  abs(v0-v1) < (accuracy*abs(v1));

         Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure TForm1.OKButtonClick(Sender: TObject);
var   v : real;
      s : string;
begin
      MsgLabel.Caption:='vZł'; UpDate;
      v:=Gauss_Legendre( -1.0, 1.0, f );
      Str( 2*v:10:7, s );
      MsgLabel.Caption:=' = '+s;
end;

end.
