unit UNewton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Timer1: TTimer;
    StartButton: TButton;
    StopButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


type     real = extended;
         integer = Longint;

const    GP_W    = 500;     //  tH[̕
         GP_H    = 350;     //  tH[̍
         g_scale = 100;     //  Wl-> Canvas̕ϊXP[
         init_vx = 2.5;     //  x̏l
         dt      = 0.0001;  //  l

var      x_size, y_size : integer;
         x0, y0, x1, y1,
         v0x, v0y, v1x, v1y : real;



function  x_coord( x : real ) : integer;  //  xW->Canvas̈ʒuij
  begin
          x_coord:=round(0.5*x_size+g_scale*x);
  end;


function  y_coord( y : real ) : integer;  //  yW->Canvas̈ʒuicj
  begin
          y_coord:=round(0.5*y_size-g_scale*y);
  end;


procedure  Draw_Circle( x, y : real;      //  ~Ղ̕`
                        r : integer  );
  var  ix, iy, r_2 : integer;
  begin
       ix:=x_coord(x);  iy:=y_coord(y);
       r_2:=r div 2;
       Form1.Image1.Canvas.Ellipse( ix-r_2, iy-r_2, ix+r_2, iy+r_2 );
  end;


(*     tH[̐        *)

procedure TForm1.FormCreate(Sender: TObject);
var   r2, inv_r3, fx, fy : real;
begin
      Timer1.Enabled:=false;               //  ^C}[~
      Timer1.Interval:=100;                //  ^C}[̊Ԋui~bj

      Top:=0;  Left:=0;                    //  tH[̈ʒu
      ClientWidth:=GP_W;
      ClientHeight:=GP_H;
      Form1.Caption:='Newton';
      x_size:=ClientWidth;                 //  C[W(Canvas)̕
      y_size:=trunc(0.8*ClientHeight);     //  C[W(Canvas)̍

      with Image1 do
        begin
                  (*    C[Ẅʒu   *)
          Top:=Form1.ClientOrigin.y+Trunc(0.2*ClientHeight);
          Left:=0;

          Width:=x_size; Height:=y_size;
        end;
      StartButton.Top:=0;  StopButton.Top:=0;     //  {^̈ʒu

       (*  Canvas̏   *)

      with Image1.Canvas do
        begin
          Pen.Color:=clBlack;
          Brush.Color:=clBlack;
          Rectangle( 0, 0, x_size, y_size );
          Pen.Color:=clWhite;
          Brush.Color:=clWhite;
          Draw_Circle( 0.0, 0.0, 20 );
          Pen.Color:=clAqua;
          Brush.Color:=clAqua;
          Draw_Circle( 0.0, 1.0, 10 );
        end;

        (*  ^̏  *)

      x0:=0.0; y0:=1.0;
      x1:=0.0; y1:=0.0;
      r2:=sqr(x0-x1)+sqr(y0-y1);
      inv_r3:=exp(-1.5*ln(r2));
      fx:=(x0-x1)*inv_r3;
      fy:=(y0-y1)*inv_r3;
      v0x:=init_vx+0.5*dt*(-8*fx);
      v0y:=0.0    +0.5*dt*(-8*fy);
      v1x:=init_vx/(-8)+0.5*dt*fx;
      v1y:=0.0          +0.5*dt*fy;
end;     {    FormCreate   }

procedure TForm1.StartButtonClick(Sender: TObject);
begin
          Timer1.Enabled:=true;      //  ^C}[EI
end;



procedure TForm1.StopButtonClick(Sender: TObject);
begin
          Timer1.Enabled:=false;     //  ^C}[EIt
end;


(*     ^C}[ECxg    *)

procedure TForm1.Timer1Timer(Sender: TObject);
var   prev_x0, prev_y0, prev_x1, prev_y1,
      r2, inv_r3, fx, fy : real;
      i          : integer;
      t1, t2, t3 : DWORD;
      s1, s2 : string;
begin
      prev_x0:=x0; prev_y0:=y0;
      prev_x1:=x1; prev_y1:=y1;

      t1:=GetTickCount;

       (*  ^̍XV   *)

      for i:=1 to 100 do
        begin
          x0:=x0+dt*v0x;
          y0:=y0+dt*v0y;
          x1:=x1+dt*v1x;
          y1:=y1+dt*v1y;

          r2:=sqr(x0-x1)+sqr(y0-y1);
          inv_r3:=exp(-1.5*ln(r2));
          fx:=(x0-x1)*inv_r3;
          fy:=(y0-y1)*inv_r3;

          v0x:=v0x+dt*(-8*fx);
          v0y:=v0y+dt*(-8*fy);
          v1x:=v1x+dt*fx;
          v1y:=v1y+dt*fy;
        end;
      t2:=GetTickCount;

        (*  `̍XV  *)

      with Image1.Canvas do
        begin
          Pen.Color:=clBlack;
          Brush.Color:=clBlack;
          Draw_Circle( prev_x0, prev_y0, 10 );
          Draw_Circle( prev_x1, prev_y1, 20 );
          Pen.color:=clAqua;
          Brush.Color:=clAqua;
          Draw_Circle( x0, y0, 10 );
          Pen.Color:=clWhite;
          Brush.Color:=clWhite;
          Draw_Circle( x1, y1, 20 );
        end;
      t3:=GetTickCount;

      Str(t2-t1, s1);  Str(t3-t2, s2);
      Canvas.TextOut(0, 0, s1 + ' - ' + s2);
end;

end.
