unit UPlot1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TForm2 = class(TForm)
    XLabel: TLabel;
    YLabel: TLabel;
    XEdit: TEdit;
    YEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    LWLabel: TLabel;
    LWEdit: TEdit;
    Label1: TLabel;
    PropFont: TLabel;
    PropFontEdit: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form2: TForm2;

implementation

uses   Printers,  //  Printergp̂
       UDBApp;    //  Form1(Table1)̃jbg

{$R *.DFM}

type   real = Extended;
       integer = Longint;

procedure TForm2.FormCreate(Sender: TObject);
begin
        Top:=0;  Left:=0;
        XEdit.Text:='2000';          //  PC-PR1000/4Rpł
        YEdit.Text:='2000';          //  PC-PR1000/4Rpł
        LWEdit.Text:='5';            //  PC-PR1000/4Rpł
        PropFontEdit.Text:='0.01';   //  PC-PR1000/4Rpł
        Label1.Caption:='lݒ肵Ĉ{^ĉ';
        Visible:=true;
end;

procedure TForm2.ExitButtonClick(Sender: TObject);
begin
          Close;
end;


procedure TForm2.OKButtonClick(Sender: TObject);
var   n, x_frame_s, y_frame_s, i : Longint;
      x, y : array[1..100] of real;
      Min_x, Min_y, Max_x, Max_y,
      s_x, s_xx, s_y, s_xy, a, b : real;
      s, s1 : string;

  function  x_coord( x : real ) : Longint;
    begin
         x_coord:=round(0.1*x_frame_s
                   +0.8*x_frame_s*(x-Min_x)/(Max_x-Min_x));
    end;


  function  y_coord( y : real ) : Longint;
    begin
         y_coord:=round(0.9*y_frame_s
                   -0.8*y_frame_s*(y-Min_y)/(Max_y-Min_y));
    end;


  procedure  Plot_Score( ix, iy : Longint );
    var  r : Longint;
    begin
         r:=round(0.01*x_frame_s);
         Printer.Canvas.Ellipse( ix-r, iy-r, ix+r, iy+r );
    end;

begin   {  OKButtonClick   }
     with Form1 do
       begin
         with Table1 do
           while not BOF do Prior;

         n:=0;
         with Table1 do
             while not EOF do
               begin
                 n:=n+1;
                 x[n]:=Table1Size.Value;
                 y[n]:=Table1Weight.Value;
                 Next;
               end;
       end;

     Min_x:=x[1];  Max_x:=x[1];
     Min_y:=y[1];  Max_y:=y[1];
     for i:=2 to n do
       begin
         if Min_x > x[i] then Min_x:=x[i];
         if Max_x < x[i] then Max_x:=x[i];
         if Min_y > y[i] then Min_y:=y[i];
         if Max_y < y[i] then Max_y:=y[i];
       end;
          
     x_frame_s:=StrToInt(XEdit.Text);
     y_frame_s:=StrToInt(YEdit.Text);

     Label1.Caption:='}ł'; UpDate;

     Printer.BeginDoc;
     with Printer.Canvas do
       begin
         Pen.Color:=clBlack;
         Pen.Width:=StrToInt(LWEdit.Text);
         Rectangle( round(0.05*x_Frame_s), round(0.05*y_frame_s),
                    round(0.95*x_frame_s), round(0.95*y_frame_s) );

         for i:=1 to n do
           Plot_Score( x_coord(x[i]), y_coord(y[i]) );

         Font.Size:=round(StrToFloat(PropFontEdit.Text)*x_Frame_s);
         TextOut(round(0.1*x_frame_s), y_frame_s,
                 'w==>TCY   x==>d');
         TextOut(round(0.1*x_frame_s), round(1.1*y_frame_s),
                 'Y = a*X + b');

       (*  A y=ax+b ̌W̌vZ  *)

         s_x :=0.0;
         s_xx:=0.0;
         s_y :=0.0;
         s_xy:=0.0;
         for i:=1 to n do
           begin
             s_x :=s_x  + x[i];       (*@w̘a      *)
             s_xx:=s_xx + sqr(x[i]);  (*  ŵQa  *)
             s_y :=s_y  + y[i];       (*  x̘a      *)
             s_xy:=s_xy + x[i]*y[i];  (*  XY̘a      *)
           end;

         a:=(n*s_xy-s_x*s_y)/(n*s_xx-sqr(s_x));
         b:=(s_xx*s_y-s_x*s_xy)/(n*s_xx-sqr(s_x));

         Str(a:7:2,s);  Str(b:7:2,s1);
         TextOut(round(0.1*x_frame_s), round(1.2*y_frame_s),
                 'a ='+s+'   b ='+s1);

         MoveTo( round(x_coord(Min_x)),
                 round(y_coord(a*Min_x+b)) );
         LineTo( round(x_coord(Max_x)),
                 round(y_coord(a*Max_x+b)) );                
       end;
     Printer.EndDoc;  

     Label1.Caption:='}I';
end;    {  OKButtonClick   }

end.
