unit UMandelbrot;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    StartButton: TButton;
    procedure StartButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type  Real    = Extended;
      Complex = record
                       Re, Im : Real;
                end;


function  c_abs( a : complex ) : real;
  begin
        c_abs:=sqrt( sqr(a.Re)+sqr(a.Im) );
  end;


function  c_add( a, b : complex ) : complex;
  begin
         with Result do
           begin
                 Re:=a.Re+b.Re;
                 Im:=a.Im+b.Im;
           end;
  end;


function  c_mult( a, b : complex ) : complex;
  begin
          with Result do
            begin
                  Re:=a.Re*b.Re-a.Im*b.Im;
                  Im:=a.Re*b.Im+a.Im*b.Re;
            end;
  end;


procedure  check_c(      c : complex;
                    var  N : integer );
  var   z : complex;
  begin
         N:=0;  z.Re:=0.0; z.Im:=0.0;
         repeat
               z:=c_add( c_mult( z, z ), c );
               N:=N+1;
         until  (c_abs(z) > 2.0) or (N > 100);
  end;


procedure TForm1.StartButtonClick(Sender: TObject);
  const  R0 = -0.220;
         R1 = -0.205;
         I0 =  0.680;
         I1 =  0.693;
         s_frame = 600;
         L_Color : array[0..6] of TColor
                 = ( clWhite, clFuchsia, clYellow,
                     clLime, clAqua, clBlue, clBlack );
  var    ix, iy, N, Id_Color : integer;
         c : complex;
  begin
         StartButton.Visible:=false;
         Top:=0;  Left:=0;
         ClientHeight:=s_frame;
         ClientWidth:=s_frame;
         with canvas do
           begin
             Pen.Color:=clGray;
             Brush.Color:=clGray;
             Rectangle(Top, Left, ClientHeight, ClientWidth);
             for ix:=Left to Left+ClientWidth do
               for iy:=Top to Top+ClientHeight do
                 begin
                   with c do
                     begin
                       Re:=R0+(ix-Left)*(R1-R0)/ClientWidth;
                       Im:=I1+(iy-Top)*(I0-I1)/ClientHeight;
                     end;
                   check_c( c, N );
                   Id_Color:=trunc(sqr(N)*6.0/10001);
                   pixels[ix, iy]:=L_Color[Id_Color];
                 end;
           end;
  end;

end.
