unit UKoch;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    StartButton: TButton;
    procedure FormDblClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure StartButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    x_pos, y_pos, theta : real;
    procedure ca_init( x0, y0 : integer );
    procedure ca_turn( angle : real );
    procedure ca_line( L : real );
    procedure Koch( n : integer;
                    L : real );
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure  TForm1.ca_init( x0, y0 : integer );
  begin
         with canvas do
           begin
             Pen.Color:=clWhite;
             Brush.Color:=clWhite;
             Rectangle( 0, 0, ClientWidth, ClientHeight );
             Pen.Color:=clBlack;
           end;

         x_pos:=x0;
         y_pos:=ClientHeight-y0;
         canvas.MoveTo( round(x_pos), round(y_pos) );
         theta:=0.0;
  end;


procedure  TForm1.ca_turn( angle : real );
  begin
           theta := theta + pi*angle/180;
  end;


procedure  TForm1.ca_line( L : real );
  var      x1, y1 : real;
  begin
           x1:=x_pos+L*cos(theta);
           y1:=y_pos-L*sin(theta);
           canvas.LineTo( round(x1), round(y1) );
           x_pos:=x1;
           y_pos:=y1;
  end;


procedure  TForm1.Koch( n : integer;
                        L : real );
  begin
           if n > 1
             then
               begin
                 Koch( n-1, L/3 );
                 ca_turn( 60.0 );
                 Koch( n-1, L/3 );
                 ca_turn( -120.0 );
                 Koch( n-1, L/3 );
                 ca_turn( 60.0 );
                 Koch( n-1, L/3 );
               end
             else
                 ca_line( L );
  end;


procedure TForm1.StartButtonClick(Sender: TObject);
const     FSize = 500;
begin
          StartButton.Visible:=False;
          Top:=0; Left:=0;
          ClientHeight:=FSize;
          ClientWidth:=FSize;
          ca_init( round(0.05*ClientWidth),
                   round(ClientHeight/3) );
          Koch( 6, 0.9*ClientWidth );
end;


procedure TForm1.FormDblClick(Sender: TObject);
begin
          Close;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
             StartButtonClick(Sender);
end;

end.
