unit USierpinski;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TVertex = record
              x, y : real;
            end;


type
  TForm1 = class(TForm)
    StartButton: TButton;
    procedure FormDblClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure StartButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure gasket( n : integer;
                      p1, p2, p3 : TVertex );
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function  v2p( p : TVertex ) : TPoint;
  begin
          with Result do
            begin
              x:=round(p.x);
              y:=round(p.y);
            end;
  end;

procedure TForm1.gasket( n : integer;
                         p1, p2, p3 : TVertex );
  var     pa, pb, pc : TVertex;
  begin
          if n > 1 then
            begin
              pa.x:=(p1.x+p2.x)/2;
              pa.y:=(p1.y+p2.y)/2;
              pb.x:=(p2.x+p3.x)/2;
              pb.y:=(p2.y+p3.y)/2;
              pc.x:=(p3.x+p1.x)/2;
              pc.y:=(p3.y+p1.y)/2;
              canvas.Polygon
                     ([v2p(pa), v2p(pb), v2p(pc)]);
              gasket( n-1, p1, pa, pc );
              gasket( n-1, pa, p2, pb );
              gasket( n-1, pc, pb, p3 );
            end;
  end;


procedure TForm1.StartButtonClick(Sender: TObject);
const     FSize = 500;
var       p1, p2, p3 : TVertex;
begin
          StartButton.Visible:=False;
          Top:=0; Left:=0;
          ClientWidth:=FSize;
          ClientHeight:=FSize;
          with canvas do
            begin
              Pen.Color:=clWhite;
              Brush.Color:=clWhite;
              Rectangle( 0, 0, FSize, FSize );
              p1.x:=0.5*FSize;
              p1.y:=0.6*FSize-0.45*FSize;
              p2.x:=0.5*FSize-0.45*FSize*cos(pi/6);
              p2.y:=0.6*FSize+0.45*FSize*sin(pi/6);
              p3.x:=0.5*FSize+0.45*FSize*cos(pi/6);
              p3.y:=p2.y;
              Pen.Color:=clBlack;
              Brush.Color:=clBlack;
              Polygon([v2p(p1), v2p(p2), v2p(p3)]);
              Brush.Color:=clWhite;
              gasket( 9, p1, p2, p3 );
            end;
end;


procedure TForm1.FormDblClick(Sender: TObject);
begin
               Close;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
             StartButtonClick(Sender);
end;

end.
