unit UCellular;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    StartButton: TButton;
    procedure FormDblClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure StartButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.StartButtonClick(Sender: TObject);
const     FSize = 450;
          CSize = 3;
          ASize = round(1.732*(FSize-2*CSize));
var       NStep, i, y_step : integer;
          c, c1 : array[-(ASize div 2)-1..(ASize div 2)+1] of Boolean;
begin
          StartButton.Visible:=False;
          Top:=0; Left:=0;
          ClientWidth:=FSize;
          ClientHeight:=FSize;
          with canvas do
            begin
              Pen.Color:=clWhite;
              Brush.Color:=clWhite;
              Rectangle( 0, 0, FSize, FSize );
            end;

          NStep:=round(exp(trunc(ln(ASize)/ln(2.0))*ln(2.0))) div 2;

          for i:=-NStep-1 to NStep+1 do c1[i]:=false;
          c1[0]:=true;
          y_step:=0;
          repeat
            y_step:=y_step+1;
            c:=c1;
            for i:=-y_step to y_step do
              begin
                if c[i] then
                  canvas.pixels[round(0.5*FSize+0.577*i),
                                round(0.5*FSize+y_step-0.5*NStep)]
                    :=clBlack;
                  c1[i]:=c[i-1] xor c[i+1];
              end;
          until  y_step >= NStep;
end;


procedure TForm1.FormDblClick(Sender: TObject);
begin
               Close;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
             StartButtonClick(Sender);
end;

end.
