unit UGenData;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    OutFileEdit: TEdit;
    MsgLabel: TLabel;
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type   Integer = Longint;
       real    = Extended;


type   TRN   = class
                   a, c, Seed : Longint;

                   procedure  init0;
                   procedure  init( x0 : Longint );
                                 // x0 may be any integer
                   function   UniRn : Extended;
               end;


procedure  TRN.init( x0 : Longint );
  begin
          a    := 69069;
          c    := 9;     //  odd integer
          Seed := x0;
  end;



procedure  TRN.init0;
  begin
          init( 1 );
  end;


function  TRN.UniRn : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        UniRn:=(Seed+rn)/rm;
  end;




var    RN : TRN;



procedure TForm1.FormActivate(Sender: TObject);
begin
     MsgLabel.Caption:='Set Output File Name';
     OutFileEdit.Text:='';
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
                 Close;
end;

procedure TForm1.OKButtonClick(Sender: TObject);
var  outfl : TextFile;
     i, j : integer;
     v    : real;
begin
     MsgLabel.Caption:='Calculation Started';

     AssignFile(outfl, OutFileEdit.Text);
     ReWrite(outfl);

     RN:=TRN.Create;

     with RN do
       begin
           init0;
           for i:=1 to 40 do
             begin
                 v:=0.0;
                 for j:=1 to 5 do
                   v:=v+UniRN;
                 v:=55+10*v;
                 writeln(outfl, round(v):10);
             end;
       end;

     RN.Free;

     CloseFile(outfl);

     MsgLabel.Caption:='Calculation Ended';
end;

end.
