unit UMean;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.OKButtonClick(Sender: TObject);
  var      mean, s, v, sd, u_v, u_sd, c,
           s3, s4, g1, g2, z : real;
           n, i  : integer;
           x  : array[1..1000] of real;
           in_f, out_f  : TextFile;
begin
     MsgLabel.Caption:='vZł'; UpDate;

    (*     o̓t@C̊t     *)

     AssignFile(in_f, InFileNmEdit.Text);
     ReSet(in_f);
     AssignFile(out_f, OutFileNmEdit.Text);
     ReWrite(out_f);

     writeln(out_f, 'f[^t@C = ', InFileNmEdit.Text);

     (*      f[^̓ǂݍ    *)

     readln(in_f, c);        //   l̓ǂݍ
     n := 0;                 //   f[^n0ɏ
     repeat
       n := n + 1;
       readln(in_f, x[n]);   //   z̗vfx[n]nԖڂ̃f[^ǂݍ
     until  x[n] <= c ;
     CloseFile(in_f);
     n := n - 1;             //   Ōɓǂݍ񂾃f[^

     (*      ̓f[^̏o           *)

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, 'x[', i, '] = ', x[i]:9:2);

     (*      ϒlmeaňvZ          *)

     s := 0.0;                     //     s0ɏ
     for i := 1 to n do
                   s := s + x[i];  //     sɃf[^x[i]̘a߂
     mean := s / n ;

     (*     UEW΍̌vZ         *)

     s := 0.0;                      //  s̏
     for i := 1 to n do
       s := s + sqr( x[i] - mean ); //  sx[i]-mean̂Qa߂
     v  := s / n ;                  //  U߂
     sd := sqrt( v );               //  W΍߂
     u_v  := s / (n-1);             //  sΕU߂
     u_sd := sqrt(u_v);             //  sΕUW΍߂

     (*     cxƐx̌vZ       *)

     s3 := 0.0;
     s4 := 0.0;
     for i := 1 to n do
       begin
           z  := (x[i] - mean) / sd ;  //  zϊ
           s3 := s3 + z * sqr(z) ;     //  Ra
           s4 := s4 + sqr(sqr(z)) ;    //  Sa
       end;
     g1 := s3 / n ;       //  cx
     g2 := s4 / n ;       //  x

     writeln(out_f);
     writeln(out_f);
     writeln(out_f, 'ϒl         =', mean:15:5);
     writeln(out_f);
     writeln(out_f, 'W΍(s) =', u_sd:15:5);
     writeln(out_f);
     writeln(out_f, 'U(s)     =', u_v :15:5);
     writeln(out_f);
     writeln(out_f, 'W΍       =', sd  :15:5);
     writeln(out_f);
     writeln(out_f, 'U           =', v   :15:5);
     writeln(out_f);
     writeln(out_f, 'cx           =', g1  :15:5);
     writeln(out_f);
     writeln(out_f, 'x           =', g2  :15:5);

     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
     ExitButton.SetFocus;
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

end.

