unit ULinearRegression;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    Image1: TImage;
    Image2: TImage;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$R+}

procedure TForm1.OKButtonClick(Sender: TObject);
var     in_f, out_f : textfile;
        XLabel, YLabel : string;
        n, i, j, x0, x1, y0, y1  : integer;
        x, y  : array[1..1000] of real;
        a, b, c, s_x, s_xx, s_y, s_xy,
        Sx2, Sy2, Sxy, MeanX, MeanY, r,
        MinX, MaxX, MinY, MaxY : real;


(*   _ƂAEwAxƂ
   WnAXScale,YScaleŃOtBbNX̍Wnɕϊ *)

  function XScale( x : real ) : integer;
    begin
          XScale:=Round(x);
    end;


  function YScale( y : real ) : integer;
    begin
          YScale:=Round(500-y);
    end;


 (*     XPos,YPosŃf[^gɕ\悤ɂ   *)

  function XPos( x : real ) : integer;
    begin
          XPos:=x0+20+round((x1-x0-40)*(x-MinX)/(MaxX-MinX));
    end;


  function YPos( y : real ) : integer;
    begin
          YPos:=y0+20+round((y1-y0-40)*(y-MinY)/(MaxY-MinY));
    end;


(*   _(x,y)𒆐SƂ~`    *)

  procedure PlotData( x, y : integer );
    begin
           Image1.Canvas.Ellipse(x-3, y-3, x+3, y+3);
    end;


begin
     MsgLabel.Caption:='vZł'; UpDate;

     AssignFile(in_f, InFileNmEdit.Text);   //  ͗pt@C
     Reset(in_f);
     AssignFile(out_f, OutFileNmEdit.Text); //  o͗pt@C
     Rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', InFileNmEdit.Text);

      (*   f[^̓ǂݍ   *)

     readln(in_f, XLabel);   //  Pϗʂ̃x
     readln(in_f, YLabel);   //  Qϗʂ̃x
     readln(in_f, c);        //  l̓ǂݍ
     n := 0;                 //  f[^n̏
     repeat
          n:=n+1;
          read(in_f, x[n]);
          if x[n] > c then readln(in_f, y[n]);
     until x[n] <= c;        //  lȉ̃f[^ǂݍ܂ꂽH
     CloseFile(in_f);
     n:=n-1;

      (*  ǂݍ񂾃f[^̏o   *)

     writeln(out_f);
     writeln(out_f, 'ϗʂw̃x --> ', XLabel);
     writeln(out_f, 'ϗʂx̃x --> ', YLabel);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, '(x[', i, '], y[', i, ']) = (',
                        x[i]:9:2, ',', y[i]:9:2, ')' );

      (*   A y=ax+b ߂邽߂̌vZ   *)

     s_x :=0.0;
     s_xx:=0.0;
     s_y :=0.0;
     s_xy:=0.0;
     for i:=1 to n do
       begin
         s_x :=s_x  + x[i];       (*@w̘a      *)
         s_xx:=s_xx + sqr(x[i]);  (*  ŵQa  *)
         s_y :=s_y  + y[i];       (*  x̘a      *)
         s_xy:=s_xy + x[i]*y[i];  (*  XY̘a      *)
       end;

     a:=(n*s_xy-s_x*s_y)/(n*s_xx-sqr(s_x));     //  萔a̒l
     b:=(s_xx*s_y-s_x*s_xy)/(n*s_xx-sqr(s_x));  //  萔b̒l

       (*   Aɂl̏o  *)

     writeln(out_f);
     writeln(out_f,
       '    X =       Y =       a*X+b =    덷');
     for i:=1 to n do writeln(out_f,
       x[i]:10:3, y[i]:10:3, (a*x[i]+b):10:3,
                             (y[i]-(a*x[i]+b)):10:3);
     writeln(out_f);
     writeln(out_f,'a = ', a:15:5);
     writeln(out_f,'b = ', b:15:5);

       (*   ֌W̌vZ   *)

     MeanX:=s_x/n;   //  Pϗʂ̕ϒl
     MeanY:=s_y/n;   //  Qϗʂ̕ϒl
     Sxy:=0.0;
     Sx2:=0.0;
     Sy2:=0.0;
     for i:=1 to n do
       begin
           Sxy:=Sxy+(x[i]-MeanX)*(y[i]-MeanY);
           Sx2:=Sx2+sqr(x[i]-MeanX);
           Sy2:=Sy2+sqr(y[i]-MeanY);
       end;

     r:=Sxy/sqrt(Sx2*Sy2);          //  ֌W
     writeln(out_f);
     writeln(out_f, 'r = ', r:15:5);
     writeln(out_f, 'W = ', sqr(r):8:5);  

     closefile(out_f);      //  o̓t@C


        (*  tH[`pɐݒ肷  *)

     InFileName.Hide;   InFileNmEdit.Hide;   OKButton.Hide;
     OutFileName.Hide;  OutFileNmEdit.Hide;
     Image1.Show;
     Top:=0; Left:=0;
     ClientHeight:=550; ClientWidth:=500;
     with ExitButton do
       begin  Top:=3; Left:=3; end;
     with MsgLabel do
       begin
          Top:=3; Left:=ExitButton.Width+30;
          Caption:='`揀ł';
       end;
     UpDate;

(*   Image1ɏcɃRs[邽߂̑Qϗʂ̃xImage2ɕ`  *)

     with Image2 do
       begin
          Height:=40; Width:=445;
          with Canvas do
            begin
               Font.Height:=20;
               TextOut(round(225-0.5*textWidth(YLabel)), 0, YLabel);
            end;
       end;

  (*    Image1ɎUz}ƉA`    *)

     with Image1 do
       begin
           Top:=6+ExitButton.Height;
           Left:=0;
           Height:=500;   Width:=500;
           with Canvas do
             begin
                Pen.Color:=clWhite; Brush.Color:=clWhite;
                Rectangle(0,0,500,500);
                UpDate;

                 (*   g̕`   *)
               
                x0:=50; x1:=495;
                y0:=50; y1:=495;
                with Pen do
                  begin  Color:=clBlack; Width:=3;  end;
                Rectangle(XScale(x0), YScale(y0), XScale(x1), YScale(y1));

                (*   Pϗʂ̃x̕`   *)

                Font.Height:=20;
                TextOut(round(275-0.5*TextWidth(XLabel)),YScale(40), XLabel);
                UpDate;

              (*  Qϗʂ̃xcɂXOx]ăRs[   *)

                for i:=0 to 440 do
                  for j:=0 to 21 do
                    Pixels[XScale(10+j),YScale(50+i)]
                      :=Image2.Canvas.Pixels[i, j];
                UpDate;

      (*  XPos,YPosŗpĂXP[Op萔MinXȂǂ̐ݒ  *)

                MinX:=x[1]; MaxX:=MinX; MinY:=y[1]; MaxY:=MinY;
                for i:=2 to n do
                  begin
                      if MinX > x[i] then MinX:=x[i];
                      if MaxX < x[i] then MaxX:=x[i];
                      if MinY > y[i] then MinY:=y[i];
                      if MaxY < y[i] then MaxY:=y[i];
                  end;
                if a > 0.0
                  then
                    begin
                      if MinY > (a*MinX+b) then MinY:=a*MinX+b;
                      if MaxY < (a*MaxX+b) then MaxY:=a*MaxX+b;
                    end
                  else
                    begin
                      if MinY > (a*MaxX+b) then MinY:=a*MaxX+b;
                      if MaxY < (A*MinX+b) then MaxY:=a*MinX+b;
                    end;

              (*       A̕`      *)

                Pen.width:=2;
                MoveTo(XScale(XPos(MinX)), YScale(YPos(a*MinX+b)));
                LineTo(XScale(XPos(MaxX)), YScale(YPos(a*MaxX+b)));

               (*    f[^(x[i],y[i])̃vbg   *)

                Pen.Width:=1;
                for i:=1 to n do
                  PlotData(XScale(XPos(x[i])), YScale(YPos(y[i])));
             end;
       end;

     MsgLabel.Caption:='o̓t@C = '+OutFileNmEdit.Text;
     ExitButton.SetFocus;
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
       Image1.Hide;  Image2.Hide;
       with MsgLabel do
         begin
           Caption:='o͗pt@Cݒ肵ĉ';
         end;
end;

end.