unit UTestCorr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$R+}

procedure TForm1.OKButtonClick(Sender: TObject);
  var      c, s_x, ssx, s_y,  ssy,   sxy,
           mean_x, mean_y, R, T  : real;
           n, i  : integer;
           x, y  : array[1..1000] of real;
           in_f, out_f  : TextFile;
begin
     MsgLabel.Caption:='vZł'; UpDate;

     AssignFile(in_f, InFileNmEdit.Text);
     Reset(in_f);
     readln(in_f); readln(in_f);            //  Qsǂݔ΂
     AssignFile(out_f, OutFileNmEdit.Text);
     Rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', InFileNmEdit.Text);

     readln(in_f, c);  n := 0;
     repeat
          n:=n+1;
          read(in_f, x[n]);
          if x[n] > c then readln(in_f, y[n]);
     until  x[n] <= c ;
     CloseFile(in_f);
     n:=n-1;

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, '(x[', i, '], y[', i, ']) = (',
                      x[i]:9:2, ',', y[i]:9:2, ')' );

     s_x:=0.0; s_y:=0.0;
     for i:=1 to n do
       begin
           s_x:=s_x+x[i];   //  x̘a
           s_y:=s_y+y[i];   //  y̘a
       end;
     mean_x:=s_x/n;
     mean_y:=s_y/n;

     ssx:=0.0; ssy:=0.0; sxy:=0.0;
     for i:=1 to n do
       begin
           ssx:=ssx+sqr(x[i]-mean_x);              //  Qa
           ssy:=ssy+sqr(y[i]-mean_y);              //  Qa
           sxy:=sxy+(x[i]-mean_x)*(y[i]-mean_y);   //  Ϙa
       end;

   (*       ֌W       *)

     R:=sxy/sqrt(ssx*ssy);
     T:=R*sqrt((n-2)/(1-sqr(R)));

     writeln(out_f);
     writeln(out_f, '֌W  = ', FloatToStrF(R, ffGeneral, 9,5) );
     writeln(out_f, '       T  = ', FloatToStrF(T, ffGeneral, 9,3 ),
                    '     df = ', n-2 );

     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
     ExitButton.SetFocus;
end;


pRoceduRe TFoRm1.ExitButtonClick(SendeR: TObject);
begin
           Close;
end;

end.