unit UChiSqrOneSample;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    InFileEdit: TEdit;
    OutFileEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
      MsgLabel.Caption:='t@Cݒ肵OK{^NbNĉ';
      OutFileEdit.Text:='';
      with InFileEdit do
        begin  Text:=''; SetFocus;  end;
end;

procedure TForm1.OKButtonClick(Sender: TObject);
var out_f, in_f : TextFile;
    k, i, n : Longint;
    e, x2 : real;
    obs   : array[1..20] of Longint;

begin
      MsgLabel.Caption:='vZł'; UpDate;

      AssignFile(in_f, InFileEdit.Text); Reset(in_f);
      AssignFile(out_f, OutFileEdit.Text); Rewrite(out_f);

      readln(in_f, k);
      for i := 1 to k do  read(in_f, obs[i]);
      CloseFile(in_f);

      n := 0;
      writeln(out_f, 'f[^');
      for i := 1 to k do
        begin
              write(out_f, obs[i]:5);
              n := n + obs[i];
        end;
      writeln(out_f);
      writeln(out_f, ' = ', n);

      e := n / k ;
      writeln(out_f);
      writeln(out_f, 'e = ', e:7:1);
      x2 := 0 ;
      for i := 1 to k do
         x2 := x2 + sqr(obs[i] - e)/e ;

      writeln(out_f);
      writeln(out_f, 'Chi square = ', x2:7:2,
                     '     df = ', k-1);

      CloseFile(out_f);
      MsgLabel.Caption:='vZI܂';
      ExitButton.SetFocus;
end;

end.
