unit UChiSqrXTable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    EditInFile: TEdit;
    LabelMssg: TLabel;
    LabelInFile: TLabel;
    LabelOutFile: TLabel;
    EditOutFile: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormActivate(Sender: TObject);
begin
        LabelMssg.Caption:='t@Cݒ肵ĉ';
        EditOutFile.Text:='';
        with EditInFile do
          begin  Text:=''; SetFocus;  end;
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;



procedure TForm1.OKButtonClick(Sender: TObject);
var      out_f, in_f : TextFile;
         e, chi_square : real;
         k, r, i, j, n : Longint;
         o1, o2            : array[1..20] of Longint;
         o                 : array[1..20, 1..20] of Longint;
begin
       AssignFile(in_f, EditInFile.Text);
       reset(in_f);
       AssignFile(out_f, EditOutFile.Text);
       rewrite(out_f);

       LabelMssg.Caption:='vZn߂܂'; UpDate;

       readln(in_f, k, r);
       for i := 1 to r do
         begin
               for j := 1 to k do  read(in_f, o[i, j]);
               readln(in_f);
         end;
       CloseFile(in_f);

       writeln(out_f, '̓f[^');
       n := 0 ;
       for i := 1 to r do
         begin
               o1[i] := 0 ;
               for j := 1 to k do
                 begin
                       write(out_f, o[i, j]:5);
                       o1[i] := o1[i] + o[i, j] ;
                 end;
               writeln(out_f);

               n := n + o1[i] ;
         end;

       for j := 1 to k do
         begin
               o2[j] := 0 ;
               for i := 1 to r do  o2[j] := o2[j] + o[i, j] ;
         end;

       writeln(out_f);
       writeln(out_f, 'e = ');
       chi_square := 0.0 ;
       for i := 1 to r do
         begin
           for j := 1 to k do
             begin
                   e := o1[i] * o2[j] / n ;
                   chi_square := chi_square + sqr(o[i, j] - e)/e ;
                   write(out_f, e:7:1);
             end;
           writeln(out_f);  
         end;

       writeln(out_f);
       writeln(out_f, 'Chi square = ', chi_square:8:2,
                      '      df = ', (k-1)*(r-1) );

       CloseFile(out_f);

       LabelMssg.Caption:='vZI܂';
       ExitButton.SetFocus;
end;

end.
