unit UKruskalWallisRndm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    InFileNmEdit: TEdit;
    OutFileNmEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


(*   ̂߂̃IuWFNg  *)

type   TRN          = class
                          a, c, Seed : Longint;

                          //  葱
                          procedure  Init;   virtual;
                          procedure  Init1( s : Longint ); virtual;

                          //  lԂ֐
                          function   Uni : Extended;
                      end;
 
(*     葱     *)

procedure  TRN.Init;                 //  l͂P
  begin
          a    := 69069;
          c    := 1;
          Seed := 1;
  end;

procedure  TRN.Init1( s : Longint ); //  lsŎw
  begin
          a    := 69069;
          c    := 1;
          Seed := s;
  end;


(*       0.0 < Uni < 1.0     *)

function  TRN.Uni : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        Uni:=(Seed+rn)/rm;
  end;


var  RN : TRN;


procedure TForm1.FormActivate(Sender: TObject);
begin
       MsgLabel.Caption:='t@Cݒ肵ĉ';
       InFileNmEdit.Text:='';
       OutFileNmEdit.Text:='';
       InFileNmEdit.SetFocus;

       RN:=TRN.Create;  RN.Init;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
              Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
              RN.Free;
end;

{$R+}
procedure TForm1.OKButtonClick(Sender: TObject);
const N_Experiments = 10000;      //  _p[~e[V̉
      MaxN      = 300;             //  ̔팱Ґ̍ől
      MaxK       = 30;             //  ̍ő吔
type  TR = record
              d, R : extended;
              ID_n, ID_K : Longint;
           end;
var   infl, outfl : TextFile;
      x : array[1..MaxN, 1..MaxK] of extended;
      n : array[1..MaxK] of Longint;
      c, H, count, Sum_Tie, Correction : extended;
      K, i, j, TotalN, i1, p, q, i_exp : Longint;
      Rec : array[1..MaxN*MaxK] of TR;
      z   : array[1..MaxN*MaxK] of extended;
      VR  : TR;


(*     pԖڂq+1Ԗڂ̃f[^d̔r   *)

  function CheckQ( q : Longint ) : Boolean;
    var c : Boolean;
    begin
       c:=true;
       if q >= TotalN then c:=false else
       if Rec[p].d < Rec[q+1].d then c:=false;

       CheckQ:=c;
    end;


(*      Kruskal-Wallis̓vȞvZ    *)

  function CalcH : extended;
    var  Row : array[1..MaxK] of extended;
         i, j : Longint;
         v, SSR : extended;
    begin
         for j:=1 to K do
           begin
              v:=0.0;
              for i:=1 to n[j] do v:=v+x[i,j];
              Row[j]:=v;
           end;
         SSR:=0.0;
         for j:=1 to K do
           SSR:=SSR+sqr(Row[j])/n[j];

         CalcH:=12*SSR/(TotalN*(TotalN+1.0)) - 3.0*(TotalN+1);
    end;   {   CalcH   }


  function  IRN( h : Longint ) : Longint;     //   1 <= IRN <= h
    var t : Longint;
    begin
        t:=trunc(h*RN.Uni)+1;
        if t > h then IRN:=h else IRN:=t;
    end;

  procedure swap( var  a, b : extended );
    var c : extended;
    begin
           c:=a;  a:=b;  b:=c;
    end;

begin
     MsgLabel.Caption:='vZn߂܂'; UpDate;
     AssignFile(infl, InFileNmEdit.Text);
     Reset(infl);
     AssignFile(outfl, OutFileNmEdit.Text);
     Rewrite(outfl);
     writeln(outfl, '̓f[^t@C = ', InFileNmEdit.Text);

     readln(infl, K);     //  
     readln(infl, c);     //  f[^ǂݍݎ̃`FbNpl
     for j:=1 to K do
       begin
          n[j]:=0;
          repeat
            n[j]:=n[j]+1;
            readln(infl, x[n[j], j]);
          until x[n[j],j] < c;
          n[j]:=n[j]-1;
       end;
     CloseFile(infl);

     writeln(outfl);
     writeln(outfl, '̓f[^ =');
     for j:=1 to K do
       begin
          writeln(outfl);
          for i:=1 to n[j] do writeln(outfl, x[i,j]:9:1);
          writeln(outfl);
          writeln(outfl,'N = ',n[j]);
          writeln(outfl);
       end;

(*     ʕt̂߂Rec̏    *)

     TotalN:=0;
     for j:=1 to K do
       for i:=1 to n[j] do
         begin
            TotalN:=TotalN+1;
            with Rec[TotalN] do
              begin  d:=x[i,j]; ID_n:=i; ID_K:=j; end;
         end;

(*     בւ    *)

     for i:=1 to TotalN-1 do
       begin
          i1:=i;
          for j:=i+1 to TotalN do
            if Rec[i1].d > Rec[j].d then i1:=j;
          if i < i1 then
            begin VR:=Rec[i]; Rec[i]:=Rec[i1]; Rec[i1]:=VR; end;
       end;

(*     ʕt    *)

     Sum_Tie:=0.0;
     p:=1; q:=p;
     repeat
          while CheckQ(q) do q:=q+1;
          for i:=p to q do Rec[i].R:=0.5*(p+q);

 (*    ʂɑ΂␳p̒ľvZ   *)

          Sum_Tie:=Sum_Tie+(q-p+1)*(sqr(q-p+1)-1.0);

          p:=q+1; q:=p;
     until  p > totalN;

(*     ␳̌vZ     *)

     Correction:=1.0-Sum_Tie/(TotalN*(sqr(1.0*TotalN)-1.0));

(*     xɏʂ߂    *)

     for p:=1 to TotalN do
       with Rec[p] do x[ID_n, ID_K]:=R;

     writeln(outfl);
     writeln(outfl, '̓f[^iNj =');
     for j:=1 to K do
       begin
          writeln(outfl);
          for i:=1 to n[j] do writeln(outfl, x[i,j]:9:1);
       end;

     H:=CalcH;       //  Kruskal-WallisȞvZ

     writeln(outfl);
     writeln(outfl);
     writeln(outfl, 'H         = ', H);
     writeln(outfl, 'Correction = ', correction);
     writeln(outfl, 'H(Cl) = ', H/correction);

(*      _p[~e[V̂߂z̏   *)

     for p:=1 to TotalN do z[p]:=Rec[p].R;

     count:=1;
     for i_exp:=1 to N_Experiments do
       begin
          if (i_exp mod 1000) = 0 then
            begin
               MsgLabel.Caption:='i_exp = '+IntToStr(i_exp);
               UpDate;
            end;

(*     z̃_p[~e[V     *)

          for p:=TotalN downto 2 do
            swap( z[p], z[IRN(p)] );

(*     z̒lxɐݒ    *)

          p:=1;
          for j:=1 to K do
            for i:=1 to n[j] do
              begin
                 x[i,j]:=z[p]; p:=p+1;
              end;

(*      HCalcH葱ŎZoAf[^ɑ΂HlƔr   *)
              
          if (CalcH-H) > (-H*(1.0E-9)) then count:=count+1;
       end;

     writeln(outfl);
     writeln(outfl);
     writeln(outfl, 'Count = ', FloatToStrF(count,ffGeneral,7,1));
     writeln(outfl, 'No of permutations = ', N_Experiments+1);
     writeln(outfl, 'Significance Value = ',
                    (100.0*count/(N_Experiments+1)):5:1, ' %');

     CloseFile(outfl);
     MsgLabel.Caption:='vZI܂';
     ExitButton.Setfocus;
end;

end.