unit URndmTestSpearmanCorr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$R+}


(*   ̂߂̃IuWFNg  *)

type   TRN          = class
                          a, c, Seed : Longint;

                          //  葱
                          procedure  Init;   virtual;
                          procedure  Init1( s : Longint ); virtual;

                          //  lԂ֐
                          function   Uni : Extended;
                      end;
 
(*     葱     *)

procedure  TRN.Init;                 //  l͂P
  begin
          a    := 69069;
          c    := 1;
          Seed := 1;
  end;

procedure  TRN.Init1( s : Longint ); //  lsŎw
  begin
          a    := 69069;
          c    := 1;
          Seed := s;
  end;


(*       0.0 < Uni < 1.0     *)

function  TRN.Uni : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        Uni:=(Seed+rn)/rm;
  end;


var  RN : TRN;


const  n_data  = 1000;
       N_Permutation = 10000;
type   TVector = array[1..n_data] of real;
var    RankX, RankY : TVector;

procedure  calc_quartile( n : integer;     //  lʐ̌vZ
                          x : TVector;
                          var  q1, q3 : real );
  var      i, j : integer;
           w1, w2, v1, v2 : real;
  begin
    i:=trunc( 0.5 + n/4 );
    if abs( 0.5 + n/4 - i ) < 0.1
      then  q1 := x[i]
      else
          begin
            w1 := 0.5 + n/4 - i;  w2 := i + 1 - 0.5 - n/4;
            q1 := w2 * x[i] + w1 * x[i+1];
          end;

    j := trunc( 0.5 + 3*n/4 );
    if abs( 0.5 + 3*n/4 - j ) < 0.1
      then  q3 := x[j]
      else
          begin
            v1 := 0.5 + 3*n/4 - j;  v2 := j + 1 - 0.5 - 3*n/4;
            q3 := v2 * x[j] + v1 * x[j+1];
          end;
  end;


procedure TForm1.OKButtonClick(Sender: TObject);
  type     TRec = record
                      x, y, rnk_x, rnk_y : real;
                  end;
  var      c, q1_x, q3_x, Median_x, Min_x, Max_x,
           q1_y, q3_y, Median_y, Min_y, Max_y,
           m_r, r, t : real;
           n, i, j, k, p, q, count : Longint;
           vec   : TVector;
           data  : array[1..n_data] of TRec;
           v     : TRec;
           in_f, out_f  : TextFile;


  function  Check_x( p, q : integer ) : Boolean;
    begin
        if q >= n then Check_x:=false else
        if abs(data[p].x-data[q+1].x)
           <= ((1.0E-6)*(abs(data[p].x)+abs(data[q+1].x)))
                  then Check_x:=true
                  else Check_x:=false;
    end;
    

  function  Check_y( p, q : integer ) : Boolean;
    begin
        if q >= n then Check_y:=false else
        if abs(data[p].y-data[q+1].y)
           <= ((1.0E-6)*(abs(data[p].y)+abs(data[q+1].y)))
                  then Check_y:=true
                  else Check_y:=false;
    end;


  function CalcSpearman : real;
    var   s_xy, s_xx, s_yy : real;
          i : integer;
    begin
      s_xy:=0.0; s_xx:=0.0; s_yy:=0.0;
      for i:=1 to n do
          begin
              s_xy:=s_xy+(RankX[i]-m_r)*(RankY[i]-m_r);
              s_xx:=s_xx+sqr(RankX[i]-m_r);
              s_yy:=s_yy+sqr(RankY[i]-m_r);
          end;
      Result:=s_xy/sqrt(s_xx*s_yy);
    end;

  function  IRN( h : Longint ) : Longint; //  1 <= IRN <= h
    var t : Longint;
    begin
        t:=trunc(h*RN.Uni)+1;
        if t > h then IRN:=h else IRN:=t;
    end;

  procedure Swap( var a, b : real );
    var c : real;
    begin
          c:=a;  a:=b;  b:=c;
    end;

begin
     MsgLabel.Caption:='vZł'; UpDate;

     AssignFile(in_f, InFileNmEdit.Text);
     Reset(in_f);
     readln(in_f); readln(in_f);    //   2sǂݔ΂
     AssignFile(out_f, OutFileNmEdit.Text);
     Rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', InFileNmEdit.Text);

     readln(in_f, c);  n := 0;
     repeat
          n:=n+1;
          with data[n] do
            begin
                read(in_f, x);
                if x > c then readln(in_f, y);
            end;
     until data[n].x <= c;
     CloseFile(in_f);
     n:=n-1;

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       with data[i] do
         writeln(out_f, '(x[', i, '], y[', i, ']) = (',
                        x:9:2, ',', y:9:2, ')' );

           (*   w̏ʕt   *)

     for i:=1 to n-1 do
       begin
           k:=i;
           for j:=i+1 to n do
             if data[k].x > data[j].x then k:=j;
           if i < k then
             begin
                 v:=data[i]; data[i]:=data[k]; data[k]:=v;
             end;
       end;

     Min_x:=data[1].x;
     Max_x:=data[n].x;
     if odd(n)
       then Median_x:=data[(n div 2)+1].x
       else Median_x:=0.5*(data[n div 2].x + data[(n div 2)+1].x);
     for i:=1 to n do vec[i]:=data[i].x;
     calc_quartile( n, vec, q1_x, q3_x );

     p:=1;
     repeat
          q:=p;
          while Check_x(p,q) do q:=q+1;
          for i:=p to q do data[i].rnk_x:=0.5*(p+q);
          p:=q+1;
     until  p > n;

          (*    x̏ʕt     *)

     for i:=1 to n-1 do
       begin
           k:=i;
           for j:=i+1 to n do
             if data[k].y > data[j].y then k:=j;
           if i < k then
             begin
                 v:=data[i]; data[i]:=data[k]; data[k]:=v;
             end;
       end;

     Min_y:=data[1].y;
     Max_y:=data[n].y;
     if odd(n)
       then Median_y:=data[(n div 2)+1].y
       else Median_y:=0.5*(data[n div 2].y + data[(n div 2)+1].y);
     for i:=1 to n do vec[i]:=data[i].y;
     calc_quartile( n, vec, q1_y, q3_y );

     p:=1;
     repeat
          q:=p;
          while Check_y(p,q) do q:=q+1;
          for i:=p to q do data[i].rnk_y:=0.5*(p+q);
          p:=q+1;
     until  p > n;

     for i:=1 to n do
       with data[i] do
         begin
             RankX[i]:=rnk_x;
             RankY[i]:=rnk_y;
         end;


         (*    ʑ֌W̌vZ   *)

     m_r:=(n+1)/2;     //  N̕ϒl

     r:=CalcSpearman;

     writeln(out_f);
     writeln(out_f, '-------------------------------------');
     writeln(out_f);
     writeln(out_f, 'ŏl(X)       = ', Min_x:15:2);
     writeln(out_f);
     writeln(out_f, 'Plʐ(X) = ', q1_x:15:2);
     writeln(out_f);
     writeln(out_f, 'l(X)       = ', Median_x:15:2);
     writeln(out_f);
     writeln(out_f, 'Rlʐ(X) = ', q3_x:15:2);
     writeln(out_f);
     writeln(out_f, 'ől(X)       = ', Max_x:15:2);
     writeln(out_f);
     writeln(out_f, '-------------------------------------');
     writeln(out_f);
     writeln(out_f, 'ŏl(Y)       = ', Min_y:15:2);
     writeln(out_f);
     writeln(out_f, 'Plʐ(Y) = ', q1_y:15:2);
     writeln(out_f);
     writeln(out_f, 'l(Y)       = ', Median_y:15:2);
     writeln(out_f);
     writeln(out_f, 'Rlʐ(Y) = ', q3_y:15:2);
     writeln(out_f);
     writeln(out_f, 'ől(Y)       = ', Max_y:15:2);
     writeln(out_f);
     writeln(out_f);
     writeln(out_f, '=====================================');
     writeln(out_f);
     writeln(out_f, 'ʑ֌W    = ', r:18:5);

     if n >= 10 then     //  cf. Siegel, 1956, p.213.
       begin
         t:=r*sqrt(n-2)/sqrt(1-sqr(r));
         writeln(out_f);
         writeln(out_f, 't  = ', FloatToStrF(t,ffGeneral,9,3),
                        '     df = ', n-2);
       end;

     count:=1;
     for i:=1 to N_Permutation do
       begin
           if (i mod 100) = 0 then
             begin
                 MsgLabel.caption:='i = '+IntToStr(i);
                 UpDate;
             end;

           for j:=n downto 2 do
             swap( RankY[j], RankY[IRN(j)] );
           if (abs(CalcSpearman) - abs(r))  > (-abs(r)*(1.0E-9))
             then count:=count+1;     //  
       end;

     writeln(out_f);
     writeln(out_f, 'count = ', count);
     writeln(out_f, 'No of Permutations = ', N_Permutation+1);
     writeln(out_f, 'Significance Value = ',
                    (100.0*count/(N_Permutation+1)):6:2, ' %');  


     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
     ExitButton.SetFocus;
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
             RN:=TRN.Create;
             RN.Init;
             InFileNmEdit.Setfocus;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
             RN.Free;
end;

end.