unit UIntEstDiffNotPaired;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    InFileNmEdit: TEdit;
    Label3: TLabel;
    OutFileNmEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    AlphaEdit: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
              Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
      Form1.Caption:=' t-test';
      MsgLabel.Caption:='MWƃt@Cݒ肵ĉ';
      InFileNmEdit.Text:='';
      OutFileNmEdit.Text:='';
      AlphaEdit.Text:='';
end;



type   Real = Extended;

type   TFunc = function( x : real ) : real;

var    df : integer;


(*    Guass-Legendre̐ϕ   *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


(*   ϕԂ̂QɂGuass-Legendre̍ċAIĂяo  *)

procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))  //  x̃`FbN
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))     //  0.0̃`FbN
          and
          (abs(b-a) < 1.0)      //   ϕԂ̒̃`FbN
         then S0:=S1+S2         //   
         else                   //   QČvZ
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*   CalcIntegraľĂяoɂϕ   *)

function AdaptiveGL( a, b : real;
                     f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }


function My_Power( a, b : real ) : real;  //  ab
  begin
        My_Power:=exp(b*ln(a));
  end;



function t_kernel( x : real ) : real;   //   tz̒萔
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df, (df+1)/2);
  end;


function gamma( r : real ) : real;     //   K}֐
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;


function Cum_t_distribution( t : real ) : real;  //  tz̕z֐
  var  v : real;
  begin
      if t = 0.0
        then Cum_t_distribution:=0.5
      else if t > 0.0
        then begin
             v:=AdaptiveGL( 0.0, t, t_kernel );
             Cum_t_distribution:=0.5+gamma((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma(df/2));
        end
      else begin
             v:=AdaptiveGL( t, 0.0, t_kernel );
             Cum_t_distribution:=0.5-gamma((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma(df/2));
        end;
  end;


(*    Cum_t_distribution̓֐   *)

function DCum_t_distribution( t : real ) : real;
  begin
        DCum_t_distribution:=gamma((df+1)/2)*t_kernel(t)/
                                 (sqrt(pi*df)*gamma(df/2));
  end;


(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : real;
                      var  Root  //     f(Root) = c
                                : real );
  var  m, v : real;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  abs(U_b-L_b) < (1.0E-15)*abs(U_b);

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*    Newton@ɂ鍪̌vZ   *)

procedure Newton( var x : real;  //  ̏lA߂l͍ f(x)=c
                  c     : real;  //  ֐l
                  f,             //  ֐
                  df             //  ֐    
                        : TFunc );
  Label QP, QP0;
  var  x0, L_b, U_b : real;
       NStep : integer;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP; //  20ȏJԂ̂Ƃ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until  abs(x-x0) < ((1.0E-15)*(abs(x)+abs(x0)));
       goto QP0;

    QP :        //   Bisection@ŌvZ
       L_b:=x;
       repeat  L_b:=L_b-1.0; until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x );

    QP0 : ;
  end;   {   Newton   }





procedure TForm1.OKButtonClick(Sender: TObject);
var  InFile, OutFile : TextFile;
     x, y : array[1..100] of real;
     nx, ny, i : integer;
     c, sx, sy, MeanX, MeanY, sxx, syy, SDX, SDY,
     SDDxy, t, p, t_u : real;
begin
     MsgLabel.Caption:='vZn߂܂';
     UpDate;

     AssignFile(InFile, InFileNmEdit.Text);   //  ̓f[^t@C
     ReSet(InFile);
     AssignFile(OutFile, OutFileNmEdit.Text); //  o̓t@C
     ReWrite(OutFile);

  (*   f[^̓ǂݍ  *)

     readln(InFile, c);
     nx:=0;
     repeat
          nx:=nx+1;
          readln(InFile, x[nx]);
     until  x[nx] <= c;
     nx:=nx-1;
     ny:=0;
     repeat
          ny:=ny+1;
          readln(InFile, y[ny]);
     until  y[ny] <= c;
     ny:=ny-1;
     CloseFile(InFile);


  (*   ̓f[^̏o   *)

     writeln(OutFile, 'f[^t@C = ', InFileNmEdit.Text);
     writeln(OutFile);
     writeln(OutFile, 'f[^ =');
     for i:=1 to nx do
       writeln(OutFile, '      x[', i, '] = ', x[i]:10:2);
     writeln(OutFile);
     for i:=1 to ny do
       writeln(OutFile, '      y[', i, '] = ', y[i]:10:2 );

     sx:=0.0;
     for i:=1 to nx do sx:=sx+x[i];        //  x[i]̘a
     MeanX:=sx/nx;                         //  x[i]̕
     sy:=0.0;
     for i:=1 to ny do sy:=sy+y[i];        //  y[i]̘a
     MeanY:=sy/ny;                         //  y[i]̕

     sxx:=0.0;
     for i:=1 to nx do
       sxx:=sxx+sqr(x[i]-MeanX);           //  x[i]-MeanX̂Qa
     SDX:=sqrt(sxx/nx);                    //  x[i]̕W΍
     syy:=0.0;
     for i:=1 to ny do
       syy:=syy+sqr(y[i]-MeanY);           //  y[i]-MeanŶQa
     SDY:=sqrt(syy/ny);                    //  y[i]̕W΍

     writeln(OutFile);
     writeln(OutFile, 'X̕ = ', MeanX:10:2,
             '         X̕W΍ = ', SDX:10:2 );
     writeln(OutFile, 'Y̕ = ', MeanY:10:2,
             '         Y̕W΍ = ', SDY:10:2 );

     SDDxy:=sqrt((nx*sqr(SDX)+ny*sqr(SDY))*((1/nx)+(1/ny))/(nx+ny-2));
     t:=(MeanX-MeanY)/SDDxy;                //  ťvZ

     writeln(OutFile);
     writeln(OutFile, 't = ', FormatFloat('0.000', t),
                      '    Rx = ', nx+ny-2);

     df:=nx+ny-2;         //  tz̎Rx̐ݒ
     p:=1.0-(0.5*(1.0-0.01*StrToFloat(AlphaEdit.Text))); //  MWɑΉ
                                                         //  m̌vZ
     (*   mpɑΉtľvZ  *)
     t_u:=0.0;
     Newton( t_u, p, Cum_t_distribution, DCum_t_distribution );
     writeln(OutFile);

     (*   MԂ̏o   *)
     
     writeln(OutFile,'ϒl̍iw|xj̐M...',
                     FloatToStrF(MeanX-MeanY-t_u*SDDxy,ffGeneral,9,3),
                     '  `  ',
                     FloatToStrF(MeanX-MeanY+t_u*SDDxy,ffGeneral,9,3));
     writeln(OutFile, 'MW = ', AlphaEdit.Text, '%');

     CloseFile(OutFile);
     MsgLabel.Caption:='vZI܂';
     ExitButton.SetFocus;
end;

end.