unit UIntEstRatioVar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    InFileNmEdit: TEdit;
    Label3: TLabel;
    OutFileNmEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    AlphaEdit: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
              Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
      Form1.Caption:=' t-test';
      MsgLabel.Caption:='t@Cݒ肵ĉ';
      InFileNmEdit.Text:='';
      OutFileNmEdit.Text:='';
      AlphaEdit.Text:='';
end;


type   Real = Extended;

type   TFunc = function( x : real ) : real;


(*   Guass-Legendre̐ϕ   *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


(*   ϕԂ̂QɂJԂ   *)

procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*    CalcIntegraľĂяȍ    *)

function AdaptiveGL( a, b : real;
                          f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }



function My_Power( a, b : real ) : real;   //  ab
  begin
        My_Power:=exp(b*ln(a));
  end;


var  df1, df2 : integer;

(*   tz̒萔   *)

function t_kernel( x : real ) : real;
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df2, (df2+1)/2);
  end;


function gamma( r : real ) : real;   //  gamma֐
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;


(*   Fz̒萔   *)

function F_kernel( x : real ) : real;
  begin
        F_kernel:=My_Power(x, df1/2-1)/
                   My_Power(1+df1*x/df2, (df1+df2)/2);
  end;


(*   Fz̕z֐   *)

function Cum_F_distribution( F : real ) : real;
  var  v : real;
  begin
      if F <= 0.0
        then Cum_F_distribution:=0.0
      else if df1 <= 1
        then begin       //    tzŌvZ    F = sqr(t)
             v:=AdaptiveGL(-sqrt(F),sqrt(F),t_kernel);
             Cum_F_distribution:=gamma((df2+1)/2)*v/
                                 (sqrt(pi*df2)*gamma(df2/2));
        end
      else begin
             v:=AdaptiveGL(0.0, F, F_kernel);
             Cum_F_distribution:=v*gamma((df1+df2)/2)*My_Power(df1/df2, df1/2)
                                  /(gamma(df1/2)*gamma(df2/2));
        end;
  end;


(*    Cum_F_distribution֐   *)

function DCum_F_distribution( F : real ) : real;
  begin
      if F <= 0.0
        then
          DCum_F_distribution:=0.0
        else
          DCum_F_distribution:=F_kernel(F)
                               *gamma((df1+df2)/2)*My_Power(df1/df2, df1/2)
                               /(gamma(df1/2)*gamma(df2/2));
  end;


(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;              //  f(Root) = c
                      s, c, L_b, U_b : real;  //  L_b < Root < U_b
                      var  Root : real );
  var  m, v : real;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  abs(U_b-L_b) < (1.0E-15)*abs(U_b);

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }

    
procedure Newton( var x : real;    //  ̏l, ߂l͍ f(x)=c
                  c     : real;
                  f, df : TFunc ); //  ֐Ɠ֐  df = f'
  Label QP, QP0;
  var  x0, L_b, U_b : real;
       NStep : integer;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP;  //  20𒴂
                                         //  Bisection@ɐ؂ւ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
            if x < 0.0 then x:=0.5*x0;
       until  abs(x-x0) < ((1.0E-15)*(abs(x)+abs(x0)));
       goto QP0;

    QP :
       L_b:=x;
       repeat
             L_b:=L_b-1.0;
             if L_b < 0.0 then L_b:=0.5*(L_b+1.0);
       until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x );

    QP0 : ;
  end;   {   Newton   }


procedure TForm1.OKButtonClick(Sender: TObject);
var  InFile, OutFile : TextFile;
     x, y : array[1..100] of real;
     nx, ny, i : integer;
     c, sx, sy, MeanX, MeanY, sxx, syy, SDX, SDY,
     UBVarX, UBVarY, F, A, F_L, F_U : real;
begin
     MsgLabel.Caption:='vZn߂܂';
     UpDate;

     AssignFile(InFile, InFileNmEdit.Text);   //  ̓f[^t@C
     ReSet(InFile);
     AssignFile(OutFile, OutFileNmEdit.Text); //  o̓t@C
     ReWrite(OutFile);

  (*   f[^̓ǂݍ  *)

     readln(InFile, c);
     nx:=0;
     repeat
          nx:=nx+1;
          readln(InFile, x[nx]);
     until  x[nx] <= c;
     nx:=nx-1;
     ny:=0;
     repeat
          ny:=ny+1;
          readln(InFile, y[ny]);
     until  y[ny] <= c;
     ny:=ny-1;
     CloseFile(InFile);


  (*   ̓f[^̏o   *)

     writeln(OutFile, 'f[^t@C = ', InFileNmEdit.Text);
     writeln(OutFile);
     writeln(OutFile, 'f[^ =');
     for i:=1 to nx do
       writeln(OutFile, '      x[', i, '] = ', x[i]:10:2);
     writeln(OutFile);
     for i:=1 to ny do
       writeln(OutFile, '      y[', i, '] = ', y[i]:10:2 );

     sx:=0.0;
     for i:=1 to nx do sx:=sx+x[i];        //  x[i]̘a
     MeanX:=sx/nx;                         //  x[i]̕
     sy:=0.0;
     for i:=1 to ny do sy:=sy+y[i];        //  y[i]̘a
     MeanY:=sy/ny;                         //  y[i]̕

     sxx:=0.0;
     for i:=1 to nx do
       sxx:=sxx+sqr(x[i]-MeanX);           //  x[i]-MeanX̂Qa
     SDX:=sqrt(sxx/nx);                    //  x[i]̕W΍
     UBVarX:=sxx/(nx-1);                   //  x[i]̕sΕU
     syy:=0.0;
     for i:=1 to ny do
       syy:=syy+sqr(y[i]-MeanY);           //  y[i]-MeanŶQa
     SDY:=sqrt(syy/ny);                    //  y[i]̕W΍
     UBVarY:=syy/(ny-1);                   //  y[i]̕sΕU

     writeln(OutFile);
     writeln(OutFile, 'X̕ = ', MeanX:10:2,
             '         X̕W΍ = ', SDX:10:2 );
     writeln(OutFile, 'Y̕ = ', MeanY:10:2,
             '         Y̕W΍ = ', SDY:10:2 );

     F:=UBVarX/UBVarY;

     writeln(OutFile);
     writeln(OutFile, 'F = ', FormatFloat('0.000', F),
                      '    Rx = (', nx-1, ',', ny-1, ')' );

     df1:=nx-1; df2:=ny-1;    //  Rx̐ݒ

     (*   MWɑΉmA̐ݒ  *)

     A:=1.0-0.01*StrToFloat(AlphaEdit.Text);

     (*    AɑΉFľvZ    *)

     //   Prob(F <= F_U) = 1-A/2
     F_U:=1.0;
     Newton( F_U, 1.0-0.5*A, Cum_F_distribution, DCum_F_distribution );

     //   Prob(F <= F_L) = A/2
     F_L:=1.0;
     Newton( F_L, 0.5*A, Cum_F_distribution, DCum_F_distribution );

     (*    MԂ̏o   *)

     writeln(OutFile);
     writeln(OutFile, 'U̔iVarX/VarY)̐M = ',
                      FloatToStrF(F/F_U,ffGeneral,9,3),
                      ' ` ',
                      FloatToStrF(F/F_L,ffGeneral,9,3));
     writeln(OutFile, 'MW = ', AlphaEdit.Text, ' %');

     CloseFile(OutFile);
     MsgLabel.Caption:='vZI܂';
     ExitButton.SetFocus;
end;

end.