unit UIntEstCorr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    InFileName: TLabel;
    InFileNmEdit: TEdit;
    OKButton: TButton;
    OutFileName: TLabel;
    OutFileNmEdit: TEdit;
    ExitButton: TButton;
    MsgLabel: TLabel;
    Label1: TLabel;
    REdit: TEdit;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$R+}



type   Real = Extended;

type   TFunc = function( x : real ) : real;

(*   Guass-Legendre̐ϕ    *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


 (*    ϕԂ̂QɂJԂ   *)

procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*   ClacIntegraľĂяȍ     *)

function AdaptiveGL( a, b : real;
                          f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }


(*    WKz̒萔   *)

function Normal_Dist( x : real ) : real;
  begin
        Normal_Dist:=exp(-sqr(x)/2);
  end;


(*   WKz̕z֐   *)

function Cum_Normal( z : real ) : real;
  begin
      if z = 0.0
        then Cum_Normal:=0.5
      else if z > 0.0
        then Cum_Normal:=0.5+AdaptiveGL(0.0, z, Normal_Dist)/sqrt(2*pi)
      else
             Cum_Normal:=0.5-AdaptiveGL(z, 0.0, Normal_Dist)/sqrt(2*pi);
  end;


(*    Cum_Normal̓֐   *)

function DCum_Normal( z : real ) : real;
  begin
        DCum_Normal:=Normal_Dist(z)/sqrt(2*pi);
  end;


(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;             //  f(Root)=c
                      s, c, L_b, U_b : real; //  L_b < Root < U_b
                      var  Root : real );
  var  m, v : real;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  abs(U_b-L_b) < (1.0E-15)*abs(U_b);

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*    Newton@ɂ鍪̌vZ   *)
    
procedure Newton( var x : real;       //  f(x)=c
                  c     : real;
                  f, df : TFunc );    //  df=f'
  Label QP, QP0;
  var  x0, L_b, U_b : real;
       NStep : integer;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP;  //  20𒴂
                                         //  Bisection@ɐ؂ւ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until  abs(x-x0) < ((1.0E-15)*(abs(x)+abs(x0)));
       goto QP0;

    QP :
       L_b:=x;
       repeat  L_b:=L_b-1.0; until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x );

    QP0 : ;
  end;   {   Newton   }




procedure TForm1.OKButtonClick(Sender: TObject);
  var      c, s_x, ssx, s_y, ssy, sxy,
           mean_x, mean_y, R, T,
           z, p, z_a, z_L, z_U, r_L, r_U  : real;
           n, i  : integer;
           x, y  : array[1..1000] of real;
           in_f, out_f  : TextFile;
begin
     MsgLabel.Caption:='vZł'; UpDate;

     AssignFile(in_f, InFileNmEdit.Text);    //  ̓t@C
     Reset(in_f);
     readln(in_f); readln(in_f);             //  Qsǂݔ΂
     AssignFile(out_f, OutFileNmEdit.Text);  //  o̓t@C
     Rewrite(out_f);

     writeln(out_f, 'f[^t@C = ', InFileNmEdit.Text);

     readln(in_f, c);      //  l̓ǂݍ
     n := 0;               //  f[^n̏
     repeat
          n:=n+1;
          read(in_f, x[n]);
          if x[n] > c then readln(in_f, y[n]);
     until  x[n] <= c ;    //  ǂݍ݃f[^I̔
     CloseFile(in_f);
     n:=n-1;               //  Lf[^̒

     (*  ǂݍ݃f[^̏o   *)

     writeln(out_f);
     writeln(out_f, '̓f[^...');
     for i:=1 to n do
       writeln(out_f, '(x[', i, '], y[', i, ']) = (',
                      x[i]:9:2, ',', y[i]:9:2, ')' );

     s_x:=0.0; s_y:=0.0;
     for i:=1 to n do
       begin
           s_x:=s_x+x[i];   //  x̘a
           s_y:=s_y+y[i];   //  y̘a
       end;
     mean_x:=s_x/n;
     mean_y:=s_y/n;

     ssx:=0.0; ssy:=0.0; sxy:=0.0;
     for i:=1 to n do
       begin
           ssx:=ssx+sqr(x[i]-mean_x);              //  Qa
           ssy:=ssy+sqr(y[i]-mean_y);              //  Qa
           sxy:=sxy+(x[i]-mean_x)*(y[i]-mean_y);   //  Ϙa
       end;

   (*       ֌W       *)

     R:=sxy/sqrt(ssx*ssy);
     T:=R*sqrt((n-2)/(1-sqr(R)));

     writeln(out_f);
     writeln(out_f, '֌W  = ', FloatToStrF(R, ffGeneral, 9,5) );
     writeln(out_f, '       T  = ', FloatToStrF(T, ffGeneral, 9,3 ),
                    '     df = ', n-2 );

    (*   MԂ̌vZ   *)

     z:=0.5*ln((1+r)/(1-r));             //  tBbV[̂ϊ

     //  MWɑ΂㑤m
     p:=1.0-(0.5*(1.0-0.01*StrToFloat(REdit.Text)));

     //  Prob(x <= z_a) = p 𖞂z_ǎvZ
     z_a:=0.0;
     Newton( z_a, p, Cum_Normal, DCum_Normal );

     z_L:=z-z_a/sqrt(n-3);   //  zϊlł̐MԂ̉
     z_U:=z+z_a/sqrt(n-3);   //  zϊlł̐MԂ̏

     //   zϊl𑊊֌Wr̒lɖ߂
     r_L:=(exp(2*z_L)-1)/(exp(2*z_L)+1);
     r_U:=(exp(2*z_U)-1)/(exp(2*z_U)+1);

     (*   o̓t@Cւ̏o   *)

     writeln(out_f);
     writeln(out_f,'MW  = ',REdit.Text,'','    N = ',n);
     writeln(out_f,'M  = ',r_L:8:5, ' ` ',r_U:8:5);

     CloseFile(out_f);

     MsgLabel.Caption:='vZI܂';
     ExitButton.SetFocus;
end;


pRoceduRe TFoRm1.ExitButtonClick(SendeR: TObject);
begin
           Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
       with REdit do
         begin  Text:=''; SetFocus;  end;
end;

end.