unit UIntEstBinomial;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    EditN: TEdit;
    Label3: TLabel;
    EditK: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    EditP: TEdit;
    Memo1: TMemo;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
     with Memo1 do
       begin Lines.Clear; Font.Name:='lr SVbN'; end;
     MsgLabel.Caption:='lݒ肵ĉ';
     EditN.Text:='';
     EditK.Text:='';
     EditP.Text:='';
     EditN.Setfocus;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
             Close;
end;


procedure display( s : string );
  begin
      with Form1.Memo1.Lines do
        begin
            while count > 20 do Delete(0);
            Add( s );
        end;
  end;


function MyPower( a, b : Extended ) : Extended;  //  ab
  var  v : extended;
  begin
        if a < 0.0 then
          begin
              ShowMessage('InValid Value for a in MyPower...'
                          +'  a = '+FloatToStrF(a, ffGeneral,18,4));
              Application.Terminate;
          end;

        if a > 0.0 then
          begin
            v:=b*Ln(a);
            if v > -11356.0
              then MyPower:=exp(v)
              else MyPower:=0.0;
          end
        else begin
          if b <> 0 then MyPower:=0.0
                    else MyPower:=1.0;
        end;            
  end;


(*     Prob(x <= k)    *)

function CumBinomial( p    : Extended;
                      n, k : Longint ) : Extended;
  var  v, Combi : Extended;
       i : Longint;
  begin
       v:=0.0;  Combi:=1.0;
       if (k >= 0) and (k <= n) then
         for i:=0 to k do
           begin
             v:=v+Combi*MyPower(p,i)*MyPower(1-p,n-i);
             Combi:=Combi*(n-i)/(i+1);
           end;

       CumBinomial:=v;
  end;   {   CumBinomial   }


(*    CumBinomial̓֐    *)

function  DCumBinomial( p : Extended;
                        n, k : Longint ) : Extended;
  var  v, Combi : Extended;
       i : Longint;
  begin
       v:=0.0;  Combi:=1.0;
       if k = 0
         then v:=-n*MyPower(1-p,n-1)
         else
           begin
             if k < n
               then
                 for i:=0 to k do
                   begin
                     v:=v+Combi*MyPower(p,i-1)
                               *MyPower(1-p,n-i-1)*(i-n*p);
                     Combi:=Combi*(n-i)/(i+1);
                   end
               else
                 v:=0.0;
           end;

       DCumBinomial:=v;
  end;   {   DCumBinomial   }


(*     Prob( x >= k)     *)

function CumUBinomial( p    : Extended;
                       n, k : Longint ) : Extended;
  var  v, Combi : Extended;
       i : Longint;
  begin
       v:=0.0;  Combi:=1.0;
       if (k >= 0) and (k <= n) then
         for i:=n downto k do
           begin
             v:=v+Combi*MyPower(p,i)*MyPower(1-p,n-i);
             Combi:=Combi*i/(n+1-i);
           end;

       CumUBinomial:=v;
  end;   {   CumUBinomial   }


(*     CumBinomial̓֐    *)

function  UDCumBinomial( p : Extended;
                        n, k : Longint ) : Extended;
  var  v, Combi : Extended;
       i : Longint;
  begin
       v:=0.0;  Combi:=1.0;
       if k = n
         then v:=n*MyPower(p,n-1)
         else
           begin
             if k > 0
               then
                 for i:=n downto k do
                   begin
                     v:=v+Combi*MyPower(p,i-1)
                               *MyPower(1-p,n-i-1)*(i-n*p);
                     Combi:=Combi*i/(n+1-i);          
                   end
               else
                 v:=0.0;
           end;

       UDCumBinomial:=v;
  end;   {   UDCumBinomial   }


type  real = Extended;

type  func = function( x : Extended ) : Extended;

var   GN, GK : Longint;

function  CumB( p : Extended ) : Extended;
  begin
        CumB:=CumBinomial(p, GN, GK);
  end;

function  DCumB( p : Extended ) : Extended;
  begin
        DCumB:=DCumBinomial(p, GN, GK);
  end;

function  CumUB( p : Extended ) : Extended;
  begin
      CumUB:=CumUBinomial(p,GN,GK);
  end;

function  UDCumB( p : Extended ) : Extended;
  begin
       UDCumB:=UDCumBinomial(p,GN,GK);
  end;


(*     Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : func;
                      s, c, L_b, U_b : Extended;
                      var  Root : Extended;
                      var  Code : Longint );
  Label Q1;
  var  m, v : Extended;
  begin
         Code:=0;
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Code:=-1;
             goto Q1;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;

           display('m in Bisection = '
                   +FloatToStrF(m,ffGeneral,20,4));
         until  (abs(U_b-L_b) < (1.0E-15)*abs(U_b))
                   or
                ((abs(L_b)+abs(U_b)) < 1.0E-15)  ;

         Root:=0.5*(L_b+U_b);

      Q1 : ;
  end;   {   Bisection   }

  
(*     Newton@ɂ鍪̌vZ    *)

procedure Newton( var x : Extended;
                  c     : Extended;
                  f, df : func;
                  var Code : Longint );
  label Q1, Q2;
  var   x0, dv : Extended;
        count : Longint;
  begin
       Code:=0;
       count:=0;
       repeat
            count:=count+1;
            if count > 20 then goto Q1;
            x0:=x;
            dv:=df(x0);
            if dv = 0.0 then goto Q1;
            x:=x0+(c-f(x0))/dv;
            if x > 1.0 then x:=0.5*(1.0+x0);
            if x < 0.0 then x:=0.5*x0; 
            display( FloatToStrF(x,ffGeneral,20,4) );
       until  (abs(x-x0) < ((1.0E-15)*(abs(x)+abs(x0))))
                or
              ((abs(x)+abs(x0)) < 1.0E-15) ;
       goto Q2;

    Q1 : Code:=-1;

    Q2 : ;
  end;   {   Newton   }

procedure TForm1.OKButtonClick(Sender: TObject);
Label QP;
var  n, k, Code : Longint;
     p, LowerP, UpperP : Extended;
begin
     MsgLabel.caption:='vZn߂܂';
     UpDate;

     n:=StrToInt(EditN.text);
     k:=StrToInt(EditK.Text);
     p:=1-0.01*strToFloat(EditP.Text);

     GN:=n; GK:=k;


     if GK <= 0 then
       begin
         UpperP:=1.0-exp((Ln(p))/GN);  //  (1-UpperP)**GN = p
         MsgLabel.Caption:='MԁEEE'+'0.0'
                           +' ` '+FloatToStrF(UpperP,ffGeneral,7,5);
       end
     else if GK >= GN then
       begin
         LowerP:=exp((1/GN)*Ln(p));  //    LowerP**GN = p
         MsgLabel.Caption:='MԁEEE'+FloatToStrF(LowerP,ffGeneral,7,5)
                           +' ` '+'1.0';
       end
     else
       begin
         LowerP:=0.5;
         Newton( LowerP, 0.5*p, CumUB, UDCumB, Code );
         if Code < 0
           then Bisection( CumUB, 1.0, 0.5*p, 0.0, 1.0, LowerP, Code );
         if Code <> 0 then
           begin
               MsgLabel.Caption:='Bisection Error';
               goto QP;
           end;

         UpperP:=0.5;
         Newton( UpperP, 0.5*p, CumB, DCumB, Code );
         if Code < 0
           then Bisection( CumB, -1.0, 0.5*p, 0.0, 1.0, UpperP, Code );
         if Code <> 0 then
           begin
               MsgLabel.Caption:='Bisection Error';
           end;

         MsgLabel.Caption:='MԁEEE'+FloatToStrF(LowerP,ffGeneral,7,5)
                           +' ` '+FloatToStrF(UpperP,ffGeneral,7,5);
       end;

   QP : ExitButton.SetFocus;
end;

end.