unit UDrawGraph;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFGraph = class(TForm)
    DrawButton: TButton;
    ExitButton: TButton;
    MsgLabel: TLabel;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DrawButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  FGraph: TFGraph;

var  a0, a1, b0, b1 : Longint;

implementation

{$R *.DFM}

uses  UBayes;

procedure TFGraph.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TFGraph.FormCreate(Sender: TObject);
begin
           Position:=poScreenCenter;
end;


type   Real = Extended;

type   TFunc = function( x : real ) : real;


(*   Guass-Legendre̐ϕ    *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


(*    ϕԂ̂QɂJԂ   *)

procedure  CalcIntegral( var S0  : Extended;
                         a, b    : Extended;
                         f       : TFunc;
                         w_intvl : Extended );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < w_intvl)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f, w_intvl);
               CalcIntegral(S2, 0.5*(a+b), b, f, w_intvl);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*   ClacIntegraľĂяȍ     *)

function AdaptiveGL( a, b    : real;
                     f       : TFunc;
                     w_intvl : Extended ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f, w_intvl);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }




function My_Power( a, b : Extended ) : Extended;   //  ab
  var  v : Extended;
  begin
        if b = 0.0  then My_Power:=1.0
        else if a <= 0.0 then My_Power:=0.0
                         else begin
                           v:=b*ln(a);
                           if v < -11355.25
                             then My_Power:=0.0
                             else My_Power:=exp(v);
                         end;
  end;


var       C : Extended;   //  C = gamma(a+b)/(gamma(a)*gamma(b))


function  FBeta( p, a, b : Extended ) : Extended;  //  x[^z
  begin
        FBeta:=C*My_Power(p,a-1)*My_Power(1-p,b-1);
  end;


var  GA, GB : Extended;

function KBeta( p : Extended ) : Extended;
  begin
        KBeta:=FBeta( p, GA, GB );
  end;


(*    Draw{^̃NbNŕ`    *)

procedure TFGraph.DrawButtonClick(Sender: TObject);
var  x0, x1, y0, y1, i : Longint;
     C0, C1, CV, Max0, Max1, MaxV, w : Extended;

  //   w̉ʏ̈ʒu
  function XPos( x : Extended ) : integer;
    begin
          XPos:=Round(x0+x*(x1-x0));
    end;

  //   x̉ʏ̈ʒu
  function YPos( y : Extended ) : integer;
    begin
          YPos:=Round(y0-y*(y0-y1));
    end;

begin
       WindowState:=wsMaximized;   //   tH[̍ő剻
       DrawButton.Visible:=False;  //   Draw{^B
       with ExitButton do          //   Exit{^
         begin  Top:=0;  Left:=0;  end;

       with Canvas do
         begin
             //   Ŝ𔒂œhԂ
             Pen.Color:=clWhite; Brush.Color:=clWhite;
             Rectangle(0,0,ClientWidth,ClientHeight);

             x0:=Round(ClientWidth*0.05);  //  w̌_
             x1:=Round(ClientWidth*0.95);  //  ŵP̈ʒu
             y0:=Round(ClientHeight*0.9); //  x̌_
             y1:=Round(ClientHeight*0.1);  //  x̂P̈ʒu

             //   g̕`
             with Pen do
               begin  Width:=2; Color:=clBlack;  end;
             MoveTo(XPos(0.0),YPos(0.0));
             LineTo(XPos(0.0),YPos(1.0));
             LineTo(XPos(1.0),YPos(1.0));
             LineTo(XPos(1.0),YPos(0.0));
             LineTo(XPos(0.0),YPos(0.0));
             Font.Height:=y1 div 2;
             TextOut(XPos(0.0)-(TextWidth('0.0') div 2),
                     YPos(0.0)+(Font.Height div 2),
                     '0.0' );
             TextOut(XPos(1.0)-(TextWidth('1.0') div 2),
                     YPos(0.0)+(Font.Height div 2),
                     '1.0' );        

             //   Oz̃p[^Ԃŕ\
             Font.Color:=clRed;
             TextOut(2*ExitButton.Width, y1 div 4,
                     'a0 = '+FloatToStrF(a0,ffGeneral,5,0)
                     +'   b0 = '+FloatTostrF(b0,ffGeneral,5,0));

             //  㕪z̃p[^΂ŕ\
             Font.Color:=clGreen;
             TextOut(3*ExitButton.Width
                     +Textwidth( 'a0 = '+FloatToStrF(a0,ffGeneral,5,0)
                                 +'   b0 = '+FloatTostrF(b0,ffGeneral,5,0)),
                     y1 div 4,
                     'a1 = '+FloatToStrF(a1,ffGeneral,5,0)
                     +'    b1 = '+FloatToStrF(b1,ffGeneral,5,0));

             //   g̏        
             with Pen do
               begin  Width:=1; Color:=clWhite;  end;
             Brush.Color:=clWhite;
             Font.Color:=clBlue;

             //   Oz̃[h(Max0)
             C:=1.0;
             GA:=a0; GB:=b0;
             w:=1.0; C0:=10.0;
             repeat
               w:=w*0.5;  CV:=C0;
               Rectangle(x0+5,y1+5,x1-5,y0-5);
               TextOut(x0+5,y1+5,'w0 = '+FloatToStrF(w,ffGeneral,9,4));
               C0:=AdaptiveGL( 0.0, 1.0, KBeta, w );
             until (Abs(C0-CV) < ((1.0E-7)*(C0+CV)))
                   and
                   (C0 > 0.0);

             C:=1.0/C0;      //  OzpC̒l
             if (a0+b0-2) = 0.0 then Max0:=C
                                else Max0:=FBeta( (a0-1)/(a0+b0-2), a0, b0 );

             //   㕪z̃[h(Max1)
             C:=1.0;
             GA:=a1; GB:=b1;
             w:=w*10.0;  C1:=10.0;
             repeat
               w:=w*0.5; CV:=C1;
               Rectangle(x0+5,y1+5,x1-5,y0-5);
               TextOut(x0+5,y1+5,'w1 = '+FloatToStrF(w,ffGeneral,9,4));
               C1:=AdaptiveGL( 0.0, 1.0, KBeta, w );
             until (Abs(C1-CV) < ((1.0E-7)*(C1+CV)))
                   and
                   (C1 > 0.0);

             Rectangle(x0+5,y1+5,x1-5,y0-5);  

             C:=1.0/C1;   //  㕪zpC̒l
             if (a1+b1-2) = 0.0 then Max1:=C
                                else Max1:=FBeta( (a1-1)/(a1+b1-2), a1, b1 );

             //   MaxV = 1.05*max(Max0, Max1)
             if Max0 > Max1 then MaxV:=Max0
                            else MaxV:=Max1;
             MaxV:=1.05*MaxV;

             //   OzԂŕ`
             with Pen do
               begin  Color:=clRed;  Width:=1;  end;
             C:=1.0/C0;
             MoveTo(XPos(0.0),YPos(FBeta(0.0,a0,b0)/MaxV));
             for i:=1 to 2000 do
               LineTo(XPos(i/2000),YPos(FBeta(i/2000,a0,b0)/MaxV));

             //   㕪z΂ŕ`  
             Pen.Color:=clGreen;
             C:=1.0/C1;
             MoveTo(XPos(0.0),YPos(FBeta(0.0,a1,b1)/MaxV));
             for i:=1 to 2000 do
               LineTo(XPos(i/2000),YPos(FBeta(i/2000,a1,b1)/MaxV));  
         end;
end;

procedure TFGraph.FormActivate(Sender: TObject);
begin
         DrawButton.Setfocus;
         MsgLabel.Caption:='Draw{^NbNĉ';
end;

end.