unit UGraphRnd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type  integer = Longint;
      real    = Extended;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TForm1.OKButtonClick(Sender: TObject);
var   n_cat, n, n_max, i, x0, x1, y0, y1,
      gx0, gx1, gh, Width_cat,
      g_max, HY, WFigure, HFigure, NFigures, HdFigure : integer;
      c, x_min, x_max, gw_cat : real;
      s1, s2 : string;
      in_fl, out_fl : TextFile;
      x : array[1..1000] of real;
      cat : array[1..100] of integer;
      iboundary : array[0..100] of integer;

  function cat_id( a : real ) : integer;  //  ãJeS[l
    var   c : integer;
    begin
          c:=1;
          while (a > iboundary[c]) and (c < n_cat) do c:=c+1;
          cat_id:=c;
    end;


  procedure count( var i : integer );
    begin
            i := i + 1 ;
    end;


begin   {    OKButtonClick    }
      WindowState:=wsMaximized;     //  tH[̍ő剻
      OKButton.Hide;
      Label2.Hide;  Label3.Hide; Label4.Hide;
      with ExitButton do
        begin  Top:=0; Left:=0;  end;
      with Label1 do
        begin
            Top:=5;  Left:=ExitButton.Width*2;
            Color:=clWhite;
            Caption:='t@C = '+Edit1.Text;
        end;
      Edit1.Hide; Edit2.Hide; Edit3.Hide; Edit4.Hide;

  (*   Canvas𔒂œhԂ   *)
      with Canvas do
        begin
          Pen.Color:=clWhite;
          Brush.Color:=clWhite;
          Rectangle(0, 0, ClientWidth, ClientHeight);
        end;

      Width_cat:=StrToInt(Edit2.Text);    //  JeS[̕

      AssignFile(in_fl, Edit1.Text);
      Reset(in_fl);
      readln(in_fl, c);                   //  f[^ǂݍ݂̊l
      n:=0;
      repeat
           n:=n+1; readln(in_fl, x[n]);   //  zxɃf[^ǂݍ
      until  x[n] < c;                    //  lc菬l܂œǂ
      n:=n-1;                             //  Ōc菬f[^͎̂Ă
      CloseFile(in_fl);

      x_min:=x[1]; x_max:=x[1];           //  f[^̍őlƍŏl߂
      for i:=1 to n do
        begin
            if x_min > x[i] then x_min:=x[i];
            if x_max < x[i] then x_max:=x[i];
        end;

      iboundary[0]:=StrToInt(Edit3.Text);
      while x_min <= iboundary[0] do
         iboundary[0]:=iboundary[0]-Width_cat;

      n_cat:=0;
      while iboundary[n_cat] < x_max do
        begin
            n_cat:=n_cat+1;
            iboundary[n_cat]:=iboundary[n_cat-1]+Width_cat;
        end;

      for i:=1 to n_cat do cat[i]:=0;
      for i:=1 to n do count( cat[cat_id(x[i])] ); //  JeS[ʂ̓x̌vZ
      n_max:=0;
      for i:=1 to n_cat do
        if n_max < cat[i] then n_max:=cat[i];

   (*  Ot̊Og̐ݒ (x0,y0)A(x1,y1)E   *)

      x0:=round(0.1*ClientWidth);
      x1:=round(0.9*ClientWidth);
      y0:=round(0.1*ClientHeight);
      y1:=round(0.8*ClientHeight);

      AssignFile(out_fl, Edit4.Text);
      ReWrite(out_fl);
      writeln(out_fl);
      writeln(out_fl, 'f[^t@C = ', Edit1.Text);
      writeln(out_fl);
      writeln(out_fl);
      writeln(out_fl, 'K@@@@x');

      NFigures:=Trunc(ln(n_max)/ln(10.0))+1;
      HdFigure:=n_max div round(exp((NFigures-1)*ln(10.0)));

      with Canvas do
        begin
          Pen.Width:=2;
          Pen.Color:=clBlack;
          Brush.Color:=clWhite;
          Rectangle(x0, y0, x1, y1);       //  Ot̊Og̕`

          Font.Size:=round(0.03*(y1-y0));  //  TextOut̑̕傫
          TextOut(x0, round(0.5*y0),
                  'őx = '+IntToStr(n_max) );

          case HdFigure of
               1    : begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/2);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 2 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               TextOut(x0-(NFigures+2)*WFigure,
                                       y1-i*HY-HFigure,
                                       IntToStr(i*g_max));
                           end;

                         g_max:=2*g_max;
                      end;
               2    : begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/3);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 3 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               TextOut(x0-(NFigures+2)*WFigure,
                                       y1-i*HY-HFigure,
                                       IntToStr(i*g_max));
                           end;

                         g_max:=3*g_max;
                      end;
               3, 4 : begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/5);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 5 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               TextOut(x0-(NFigures+2)*WFigure,
                                       y1-i*HY-HFigure,
                                       IntToStr(i*g_max));
                           end;

                         g_max:=5*g_max;
                      end;
               else   begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/10);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 10 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               if i < 10 then
                                 TextOut(x0-(NFigures+2)*WFigure,
                                         y1-i*HY-HFigure,
                                         IntToStr(i*g_max))
                               else
                                 TextOut(x0-(NFigures+3)*WFigure,
                                         y1-i*HY-HFigure,
                                         IntToStr(i*g_max));
                           end;

                         g_max:=10*g_max;
                      end;
          end;

          Pen.Width:=1;
          gw_cat:=(x1-x0)/n_cat;            //  OtɂJeS[̕
          for i:=1 to n_cat do
            begin
                Brush.Color:=clBlue;
                gx0:=round(x0+0.25*gw_cat+(i-1)*gw_cat); //  _Ot̍[̈ʒu
                gx1:=round(gx0+0.5*gw_cat);             //  _Ot̉E[̈ʒu
                gh :=round(0.9*(y1-y0)*cat[i]/g_max);  //  _Ot̍
                Rectangle( gx0, y1-gh, gx1, y1 );

                Str(iboundary[i-1], s1);            //  JeS[̉l
                Str(iboundary[i],   s2);            //  JeS[̏l
                Brush.Color:=clWhite;
                TextOut(gx0, round(y1*1.02), ' '+s1);
                TextOut(gx0, round(y1*1.06), '   |');
                TextOut(gx0, round(y1*1.1), ' '+s2);

                writeln(out_fl);
                writeln(out_fl, s1+' - '+s2+'  ==>  ', cat[i]);
            end;
        end;

      CloseFile(out_fl);
      ExitButton.SetFocus;
end;    {    OKButtonClick    }

procedure TForm1.FormActivate(Sender: TObject);
begin
           Edit1.Text:='';
           Edit2.Text:='';
           Edit3.Text:='';
           Edit4.Text:='';
end;

end.