unit UScatter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    OKButton: TButton;
    ExitButton: TButton;
    Panel1: TPanel;
    Image1: TImage;
    Image2: TImage;
    OpenDialog1: TOpenDialog;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
      MsgLabel.Caption:='OK{^NbNĉ';
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;


procedure TForm1.OKButtonClick(Sender: TObject);
Label QP;
var   n, i, HTxt, WTxt, IH, IW, x0, y0, MaxV : Longint;
      c, max_x, min_x, max_y, min_y : extended;
      infl : TextFile;
      XLabel, YLabel, s : string;
      x : array[1..200, 1..2] of extended;


  function ScaleX( a : extended ) : Longint;
    begin
        ScaleX:=round(x0+0.9*(a-0.5*(min_x+max_x))*MaxV/(0.5*(max_x-min_x)));
    end;

  function ScaleY( b : extended ) : Longint;
    begin
        ScaleY:=round(y0-0.9*(b-0.5*(min_y+max_y))*MaxV/(0.5*(max_y-min_y)));
    end;


  procedure Plot( a, b : extended );
    var  r, ia, ib : Longint;
    begin
       with Image1 do
         begin
           r:=round(Height*0.005);
           ia:=ScaleX(a);
           ib:=ScaleY(b);
           Canvas.Ellipse(ia-r,ib-r,ia+r,ib+r);
         end;
    end;   {   Plot   }

begin
      MsgLabel.Caption:='`̏ł';
      UpDate;

      with OpenDialog1 do
        begin
          Title:='̓f[^t@C̐ݒ';
          if not Execute then goto QP;
          AssignFile(infl, FileName);
          Reset(infl);
        end;

      readln(infl, XLabel);    //  Pϐ̃x
      readln(infl, YLabel);    //  Qϐ̃x
      readln(infl,c);          //  l
      n:=0;
      repeat
           n:=n+1;
           read(infl, x[n,1]);
           if x[n,1] > c then readln(infl, x[n,2]);
      until  x[n,1] <= c;
      n:=n-1;                  //  f[^i΁j̑

      CloseFile(infl);

      WindowState:=wsMaximized;
      with Panel1 do
        begin
          Top:=OKButton.Height;
          Left:=0;
          Height:=Form1.ClientHeight-OKButton.Height;
          Width:=Form1.ClientWidth;
        end;

      with Image2 do
        begin
           Top:=3;   Left:=3;
           Height:=Panel1.Height div 3;
           Width:=2*Panel1.Width div 3;
           Hide;
           with Canvas do
             begin
               with Font do
                 begin
                   Height:=round(Panel1.Height*0.05);
                   Name:='lr SVbN';
                 end;
               HTxt:=TextHeight(YLabel);
               WTxt:=TextWidth(YLabel);
               TextOut(0,0, YLabel);
             end;
        end;

      with Image1 do
        begin
          Top:=3;  Left:=3;
          Height:=Panel1.Height-6;
          Width:=Panel1.Width-6;
          with Canvas do
            begin
              x0:=Width div 2;
              y0:=Round(0.45*Height);
              Pen.Width:=3;
              MaxV:=round(0.9*y0);
              rectangle(x0-MaxV, y0-MaxV, x0+MaxV, y0+MaxV);

      (*  Image2̕YLabel90x]ăRs[   *)

              for IH:=0 to HTxt do
                for IW:=0 to WTxt do
                  pixels[round(x0-1.45*MaxV)+IH,round(y0+0.5*WTxt)-IW]
                    :=Image2.Canvas.pixels[IW, IH];

        (*    Pϐ̃xXLabel̕`    *)

              with Font do
                begin
                  Height:=round(Panel1.Height*0.05);
                  Name:='lr SVbN';
                end;
              WTxt:=TextWidth(XLabel);
              textOut(round(x0-0.5*WTxt), round(y0+1.15*MaxV), XLabel);

    (*   XP[Op֐ScaleX,ScaleYŎgpŏlAől߂   *)

              min_x:=x[1,1]; max_x:=min_x;
              min_y:=x[1,2]; max_y:=min_y;
              for i:=2 to n do
                begin
                  if min_x > x[i,1] then min_x:=x[i,1];
                  if max_x < x[i,1] then max_x:=x[i,1];
                  if min_y > x[i,2] then min_y:=x[i,2];
                  if max_y < x[i,2] then max_y:=x[i,2];
                end;

      (*  f[^(x[i,1],x[i,2])̃vbg   *)

              Pen.Width:=1;
              for i:=1 to n do Plot(x[i,1], x[i,2]);

          (*    x̖ڐ   *)

              Font.Height:=round(Panel1.Height*0.03);
              MoveTo(x0-MaxV, ScaleY(max_y));
              LineTo(round(x0-1.03*MaxV), ScaleY(max_y));
              Str(max_y:9:1, s);
              s:=Trim(s)+' ';
              HTxt:=TextHeight(s);
              WTxt:=TextWidth(s);
              TextOut(round(x0-1.03*MaxV)-WTxt,
                      ScaleY(max_y)-HTxt,
                      s);
              MoveTo(x0-MaxV, ScaleY(min_y));
              LineTo(round(x0-1.03*MaxV), ScaleY(min_y));
              Str(min_y:9:1, s);
              s:=Trim(s)+' ';
              HTxt:=TextHeight(s);
              WTxt:=TextWidth(s);
              TextOut(round(x0-1.03*MaxV)-WTxt,
                      ScaleY(min_y)-HTxt,
                      s);
              MoveTo(x0-MaxV, ScaleY(0.5*(min_y+max_y)));
              LineTo(round(x0-1.03*MaxV), ScaleY(0.5*(min_y+max_y)));
              Str(0.5*(min_y+max_y):9:1, s);
              s:=Trim(s)+' ';
              HTxt:=TextHeight(s);
              WTxt:=TextWidth(s);
              TextOut(round(x0-1.03*MaxV)-WTxt,
                      ScaleY(0.5*(min_y+max_y))-HTxt,
                      s);

           (*   w̖ڐ   *)

              MoveTo(ScaleX(max_x), y0+MaxV);
              LineTo(ScaleX(max_x), round(y0+1.03*MaxV));
              Str(max_x:9:1, s);
              s:=Trim(s)+' ';
              WTxt:=TextWidth(s);
              TextOut(ScaleX(max_x)-(WTxt div 2),
                      round(y0+1.04*MaxV),
                      s);
              MoveTo(ScaleX(min_x), y0+MaxV);
              LineTo(ScaleX(min_x), round(y0+1.03*MaxV));
              Str(min_x:9:1, s);
              s:=Trim(s)+' ';
              WTxt:=TextWidth(s);
              TextOut(ScaleX(min_x)-(WTxt div 2),
                      round(y0+1.04*MaxV),
                      s);
              MoveTo(ScaleX(0.5*(min_x+max_x)), y0+MaxV);
              LineTo(ScaleX(0.5*(min_x+max_x)), round(y0+1.03*MaxV));
              Str(0.5*(min_x+max_x):9:1, s);
              s:=Trim(s)+' ';
              WTxt:=TextWidth(s);
              TextOut(ScaleX(0.5*(min_x+max_x))-(WTxt div 2),
                      round(y0+1.04*MaxV),
                      s);
            end;
        end;

      MsgLabel.Caption:='̓t@C = '+OpenDialog1.FileName;
  QP :    
      ExitButton.SetFocus;
end;

end.