unit UDrawTDistri;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    EditDF: TEdit;
    Label2: TLabel;
    EditTc: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
             Close;
end;


var Tc : Extended;
    df : integer;

type   TFunc = function( x : Extended ) : Extended;


function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


function AdaptiveGL( a, b : Extended;
                     f    : TFunc ) : Extended;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }


function My_Power( a, b : Extended ) : Extended;
  begin
        My_Power:=exp(b*ln(a));
  end;


function t_kernel( x : Extended ) : Extended;
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df, (df+1)/2);
  end;


function gamma( r : Extended ) : Extended;
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;


function Cum_t_distribution( t : Extended ) : Extended;
  var  v : Extended;
  begin
      if t = 0.0
        then Cum_t_distribution:=0.5
      else if t > 0.0
        then begin
             v:=AdaptiveGL( 0.0, t, t_kernel );
             Cum_t_distribution:=0.5+gamma((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma(df/2));
        end
      else begin
             v:=AdaptiveGL( t, 0.0, t_kernel );
             Cum_t_distribution:=0.5-gamma((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma(df/2));
        end;
  end;


function t_distri( t, r : Extended ) : Extended;
  var  den : Extended;
  begin
      den:=sqrt(pi*r)*gamma(r/2)*My_power(1.0+(sqr(t)/r), (r+1.0)/2);
      t_distri:=gamma((r+1.0)/2)/den;
  end;



procedure TForm1.OKButtonClick(Sender: TObject);
  var  i : integer;
       p : Extended;

  function XPos( x : Extended ) : integer;
    begin
           XPos:=Round(300+280*x/(1.3*Tc));
    end;


  function YPos( y : Extended ) : Integer;
    var  v : Extended;
    begin
          v:=t_distri(0.0, df);
          YPos:=Round(350-300*y/v);
    end;


begin    {    OKButtonClick    }
     df:=StrToInt(EditDF.Text);
     Tc:=StrToFloat(EditTc.Text);

     with ExitButton do
       begin
           Top:=0; Left:=0;
       end;

     with OKButton do
       begin
           Top:=0; Left:=ExitButton.Width;
           Visible:=False;
       end;

     Label1.Visible:=False;
     Label2.Visible:=False;
     EditTc.Visible:=False;

     with EditDF do
       begin
           Top:=0; Left:=2*ExitButton.Width;
           Text:='df = '+IntToStr(df);
       end;

     ClientWidth:=600; ClientHeight:=400;
     Position:=poScreenCenter;

 (*   p = P(T < -Tc or Tc < T) ̌vZ   *)

     p:=2*(1-Cum_t_distribution(Tc));

     with Canvas do
       begin
           Pen.Color:=clWhite; Brush.Color:=clWhite;
           Rectangle(0,0,600,400);

        (*    W̕`    *)

           Pen.Width:=2;
           Pen.Color:=clBlack;
           MoveTo(XPos(-1.3*Tc), YPos(0.0));
           LineTo(XPos(1.3*Tc), YPos(0.0));
           MoveTo(XPos(0.0), YPos(-0.1*t_distri(0.0, df)));
           LineTo(XPos(0.0), YPos(1.2*t_distri(0.0, df)));

       (*     tz̊mx֐̕`     *)

           Pen.Width:=1;
           MoveTo(XPos(-1.3*Tc), YPos(t_distri(-1.3*Tc,df)));
           for i:=-99 to 100 do
             LineTo(XPos(1.3*Tc*i/100),
                    YPos(t_distri(1.3*Tc*i/100, df)));

        (*    X-Tc,Tcڐ    *)

           MoveTo(XPos(-Tc), YPos(0.0));
           LineTo(XPos(-Tc), YPos(-0.05*t_distri(0.0, df)));
           with Font do
             begin
               Height:=20;  Name:='lr SVbN';
             end;
           TextOut(XPos(-Tc), YPos(-0.05*t_distri(0.0, df))+5, '-Tc');
           MoveTo(XPos(Tc), YPos(0.0));
           LineTo(XPos(Tc), YPos(-0.05*t_distri(0.0, df)));
           TextOut(XPos(Tc), YPos(-0.05*t_distri(0.0, df))+5, 'Tc');

         (*     Tc̒l̕\     *)

           TextOut(30,50,'   Tc = '+FormatFloat('0.0',Tc));

        (*   P(|T| > Tc) ̕\   *)

           TextOut(30,70,'Alpha = '+FormatFloat('0.0', p*100)+'%');

        (*   P(T < -Tc)̗̈ԂœhԂ   *)

           Pen.Color:=clBlack;
           Brush.Color:=clRed;
           MoveTo(XPos(-Tc), YPos(0.0));
           LineTo(XPos(-Tc), YPos(t_distri(-Tc,df)));
           Pen.Color:=clRed;
           MoveTo(XPos(-1.3*Tc), YPos(0.0));
           LineTo(XPos(-1.3*Tc), YPos(t_distri(-1.3*Tc,df)));
           FloodFill(XPos(-Tc)-1, YPos(0.0)-2, clWhite, fsSurface);

         (*   P(T > Tc)̗̈ԂœhԂ   *)

           Pen.Color:=clBlack;
           Brush.Color:=clRed;
           MoveTo(XPos(Tc), YPos(0.0));
           LineTo(XPos(Tc), YPos(t_distri(Tc,df)));
           Pen.Color:=clRed;
           MoveTo(XPos(1.3*Tc), YPos(0.0));
           LineTo(XPos(1.3*Tc), YPos(t_distri(-1.3*Tc,df)));
           FloodFill(XPos(Tc)+1, YPos(0.0)-2, clWhite, fsSurface);
           if Pixels[XPos(1.3*Tc), YPos(0.0)+3] = clRed then
             begin
                 Brush.Color:=clWhite;
                 FloodFill(XPos(Tc)+1, YPos(0.0)-2, clRed, fsSurface);
             end;
       end;

     ExitButton.SetFocus;
end;  {    OKButtonClick     }


procedure TForm1.FormActivate(Sender: TObject);
begin
         EditDF.Text:='';
         EditTc.Text:='';
         EditDF.SetFocus;
end;

end.