unit UCalcLegendre;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label3: TLabel;
    OutFileEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    NEdit: TEdit;
    Memo1: TMemo;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
               Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
        MsgLabel.Caption:='N̒lƏo͗pt@Cݒ肵Ă';
        Memo1.Lines.Clear;
        OutFileEdit.Text:='';
        NEdit.Text:='';
end;


type  Real = Extended;

type  TFunc = function( x : real ) : real;


procedure  Bisection( f : TFunc;
                      s, c, L_b, U_b : real;
                      var  Root : real;
                      Acc : real );
  var  m, v : real;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  (abs(U_b-L_b) < (Acc*(abs(U_b)+abs(L_b))))
                  or
                ((abs(U_b)+abs(L_b)) < Acc);

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


procedure Newton( var x : real;
                  c     : real;
                  f, df : TFunc;
                  Acc   : real );
  var  x0 : real;
       s  : string;
  begin
       repeat
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);

            with Form1.Memo1.Lines do
              begin
                 while count > 9 do Delete(0);
                 Str(x, s);
                 Add('x = ' + s);
                 Form1.UpDate;
              end;
       until  (abs(x-x0) < (Acc*(abs(x)+abs(x0))))
                 or
              ((abs(x)+abs(x0)) < Acc)  ;
  end;   {   Newton   }


(*  Wh̑   *)

function Legendre_P( x : real;
                     n : integer ) : real;
  var  v1, v2 : real;
  begin
      if n <= 0 then Legendre_P:=1 else
      if n <= 1 then Legendre_P:=x
      else
        begin
            v1:=Legendre_P(x,n-1);
            v2:=Legendre_P(x,n-2);
            Legendre_P:=((2*n-1)*x*v1-(n-1)*v2)/n;
        end;
  end;   {   Legendre_P   }


(*   Wh̑̓֐   *)

function  D_Legendre_P( x : real;
                        n : integer ) : real;
  var  v0, v1, v2 : real;
  begin
      if n <= 0 then D_Legendre_P:=0 else
      if n <= 1 then D_Legendre_P:=1
      else
        begin
            v0:=Legendre_P(x,n-1);
            v1:=D_Legendre_P(x,n-1);
            v2:=D_Legendre_P(x,n-2);
            d_Legendre_P:=((2*n-1)*(v0+x*v1)-(n-1)*v2)/n;
        end;
  end;


var   G_N : integer;

function F_Root( x : real ) : real;
  begin
        F_Root:=Legendre_P(x, G_N);
  end;


function DF_Root( x : real ) : real;
  begin
        DF_Root:=D_Legendre_P(x, G_N);
  end;


procedure TForm1.OKButtonClick(Sender: TObject);
var   Out_f : TextFile;
      Acc_s, ck, ck1, s_t, t0, t1 : real;
      Prec_s, i : Integer;
      x, w : array[1..10] of real;
begin
      MsgLabel.Caption:='vZł';
      UpDate;
      G_N:=StrToInt(NEdit.Text);
      AssignFile(Out_f, OutFileEdit.Text); rewrite(out_f);

      //   x̐ݒ
      Acc_s:=1.0; Prec_s:=0;
      repeat
           Acc_s:=Acc_s*0.1; Prec_s:=Prec_s+1;
           ck:=1.0;
           ck1:=ck+Acc_s;
      until  ck = ck1;
      Prec_s:=Prec_s-2;  //   o͂̌̎wɗp
      Acc_s:=Acc_s*10.0;
      writeln(Out_f, 'Acc_s̒l = ', Acc_s);
      writeln(Out_f);

      //  i_jx[i]Ədw[i]̌vZ
      s_t:=0.1/G_N;
      t0:=-1.0; t1:=t0;
      for i:=1 to G_N do
        begin
            repeat
                 t1:=t1+s_t;
            until  (F_Root(t0)*F_Root(t1)) < 0.0;

            t1:=t1+s_t;

            Bisection( F_Root, F_Root(t1), 0.0, t0, t1,
                       x[i], 1.0E-5 );

            Newton( x[i], 0.0, F_Root, DF_Root, Acc_s );

            w[i]:=2.0/((1-sqr(x[i]))*sqr(DF_Root(x[i])));

            writeln(out_f, 'x[',i,'] = ', x[i]:(Prec_s+9),
                    '       w[',i,'] = ', w[i]:(Prec_s+9) );

            t0:=x[i]+s_t; t1:=t0;
        end;

      CloseFile(out_f);
      MsgLabel.Caption:='vZI܂';
      ExitButton.Setfocus;
end;

end.