unit UCalcZ;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    PLabel: TLabel;
    PEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormActivate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
         MsgLabel.caption:='mݒ肵ĉ';
         PEdit.Text:='';
end;


type   Real = Extended;

type   TFunc = function( x : real ) : real;


function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


function AdaptiveGL( a, b : real;
                          f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }



function Normal_Dist( x : real ) : real;
  begin
        Normal_Dist:=exp(-sqr(x)/2);
  end;


function Cum_Normal( z : real ) : real;
  begin
      if z = 0.0
        then Cum_Normal:=0.5
      else if z > 0.0
        then Cum_Normal:=0.5+AdaptiveGL(0.0, z, Normal_Dist)/sqrt(2*pi)
      else
             Cum_Normal:=0.5-AdaptiveGL(z, 0.0, Normal_Dist)/sqrt(2*pi);
  end;


function DCum_Normal( x : real ) : real;
  begin
        DCum_Normal:=exp(-sqr(x)/2)/sqrt(2*pi);
  end;


(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : real;
                      var  Root  //     f(Root) = c
                                : real );
  var  m, v : real;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  abs(U_b-L_b) < (1.0E-15)*abs(U_b);

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*    Newton@ɂ鍪̌vZ   *)

procedure Newton( var x : real;  //  ̏lA߂l͍ f(x)=c
                  c     : real;  //  ֐l
                  f,             //  ֐
                  df             //  ֐    
                        : TFunc );
  Label QP, QP0;
  var  x0, L_b, U_b : real;
       NStep : integer;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP; //  20ȏJԂ̂Ƃ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until  abs(x-x0) < ((1.0E-15)*(abs(x)+abs(x0)));
       goto QP0;

    QP :        //   Bisection@ŌvZ
       L_b:=x;
       repeat  L_b:=L_b-1.0; until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x );

    QP0 : ;
  end;   {   Newton   }


procedure TForm1.OKButtonClick(Sender: TObject);
Label  Q1;
var       p, z : real;
       s    : string;
begin
        MsgLabel.Caption:='Calculation Started';

        p:=StrToFloat(PEdit.Text);

        if (p <= 0.0) or (p >= 1.0) then
          begin
              MsgLabel.Caption:='Probability Value is inappropriate';
              goto Q1;
          end;

        z:=0.0;
        Newton( z, p, Cum_Normal, DCum_Normal );

        Str( z:9:5, s );
        MsgLabel.Caption:='Zp = '+s;
    Q1: ExitButton.SetFocus;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
             close;
end;

end.