unit UCum_FAdap;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    FEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    DF1Edit: TEdit;
    Label3: TLabel;
    DF2Edit: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
           MsgLabel.Caption:='elƎRxdf1,df2ݒ肵ĉ';
           DF1Edit.Text:='';
           DF2Edit.Text:='';
           FEdit.Text:='';
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;


type   Real = Extended;

type   TFunc = function( x : real ) : real;


function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < 1.0)  
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


function AdaptiveGL( a, b : real;
                          f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }



function My_Power( a, b : real ) : real;
  begin
        My_Power:=exp(b*ln(a));
  end;


var  df1, df2 : integer;

function t_kernel( x : real ) : real;
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df2, (df2+1)/2);
  end;


function gamma( r : real ) : real;
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;


function F_kernel( x : real ) : real;
  begin
        F_kernel:=My_Power(x, df1/2-1)/
                   My_Power(1+df1*x/df2, (df1+df2)/2);
  end;


function Cum_F_distribution( F : real ) : real;
  var  v : real;
  begin
      if F <= 0.0
        then Cum_F_distribution:=0.0
      else if df1 <= 1
        then begin
             v:=AdaptiveGL(-sqrt(F),sqrt(F),t_kernel);
             Cum_F_distribution:=gamma((df2+1)/2)*v/
                                 (sqrt(pi*df2)*gamma(df2/2));
        end
      else begin
             v:=AdaptiveGL(0.0, F, F_kernel);
             Cum_F_distribution:=v*gamma((df1+df2)/2)*My_Power(df1/df2, df1/2)/
                                  (gamma(df1/2)*gamma(df2/2));
        end;
  end;



procedure TForm1.OKButtonClick(Sender: TObject);
var   F, p : real;
begin
      MsgLabel.caption:='Calculation Started';

      F:=StrToFloat(FEdit.Text);
      df1:=StrToInt(DF1Edit.Text);
      df2:=StrToInt(DF2Edit.Text);

      p:=Cum_F_distribution( F );

      MsgLabel.Caption
        :='Prob( x <= '+FloatToStrF(F,ffGeneral,7,2)+' ) = '
          +FloatToStrF(p,ffGeneral,7,5);
      ExitButton.SetFocus;
end;

end.