unit UProb_U;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    LabelH: TLabel;
    LabelM: TLabel;
    EditM: TEdit;
    LabelN: TLabel;
    EditN: TEdit;
    LabelU: TLabel;
    EditU: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormActivate(Sender: TObject);
begin
       LabelH.Caption:='lݒ肵āAOK{^NbNĉ';
       EditM.Text:='';
       EditN.Text:='';
       EditU.Text:='';
       EditM.SetFocus;
end;


procedure TForm1.ExitButtonClick(Sender: TObject);
begin
              Close;
end;


type  real = Extended;
      integer = Longint;


function  combi( a, b : integer ) : real;
  var  t : real;
       i : integer;
  begin
       t:=1.0;
       if b > 0 then
         for i:=b downto 1 do
           t:=t*(a+1-i)/i;

       combi:=t;
  end;


(*
             Probability of U

             cf. Gibbons,1971,p.144
*)

function  p_u_test( m, n, u : integer ) : real;
  Label QP;
  var   v, p1, p2 : real;
  begin
        if u < 0 then
          begin  v:=0.0;  goto QP;  end;
        if u = 0 then
          begin  v:=1.0/combi(m+n,m);  goto QP;  end;
        if (u > 0) and ( (n=0) or (m=0) ) then
          begin  v:=0.0;  goto QP;  end;

        p1:=p_u_test( m, n-1, u );
        p2:=p_u_test( m-1, n, u-n );
        v:=(n*p1 + m*p2)/(m+n);

      QP: p_u_test:=v;
  end;   {   p_u_test   }




procedure TForm1.OKButtonClick(Sender: TObject);
var  m, n, u : integer;
     p       : real;
     s       : string;

 
  function  cum_prob_u( m, n, u : integer ) : real;
    var  i : integer;
         v : real;
         s : string;
    begin
          v:=0.0;
          if u >= 0 then
            for i:=0 to u do
              begin
                Str(i, s);
                LabelH.Caption:='u = '+s+' started';
                UpDate;
                v:=v+p_u_test(m,n,i);
              end;

          cum_prob_u:=v;
    end;   {   cum_prob_u   }

begin
     LabelH.Caption:='vZł';
     UpDate;
     m:=StrToInt(EditM.Text);
     n:=StrToInt(EditN.Text);
     u:=StrToInt(EditU.Text);

     p:=cum_prob_u(m,n,u);

     Str(p:7:5, s);
     LabelH.Caption:='p = '+s;

     ExitButton.SetFocus;
end;

end.
