unit UProbWilcoxon;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    LabelMssg: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EditN: TEdit;
    EditT: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


{$R+}


type      Real = Extended;
          Integer = Longint;


procedure TForm1.FormActivate(Sender: TObject);
begin
          EditN.Text:='';
          EditT.Text:='';
          LabelMssg.Caption:='lݒ肵ĉ';
          EditN.Setfocus;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
          Close;
end;


type      TPattern = class
                       Pattern : Longint;

                       procedure Init_Pattern;
                       procedure Next_Pattern;
                       function  Check_Bit( p : integer ) : integer;
                       function  Check_End( n : integer ) : Boolean;
                       procedure Get_Pattern( var s : string;
                                              n : integer );
                     end;


procedure TPattern.Init_Pattern;
  begin
          Pattern:=0;
  end;


procedure TPattern.Next_Pattern;
  begin
          Pattern:=Pattern+1;
  end;


function  TPattern.Check_Bit( p : integer ) : integer;
  var   c : Longint;
  begin
        c:=1;
        if p > 1 then c:=c shl (p-1);
        if (pattern and c) = 0
          then  Check_Bit:=0
          else  Check_Bit:=1;
  end;


function  TPattern.Check_End( n : integer ) : Boolean;
  var   c : Longint;
  begin
        c:=1 shl n;
        if (pattern and c) <> 0
          then  Check_End:=true
          else  Check_End:=false;
  end;


procedure TPattern.Get_Pattern( var s : string;
                                    n : integer );
  var   i : integer;
  begin
        s:='';
        for i:=n downto 1 do
          if Check_Bit(i) = 0 then s:=s+'0'
                              else s:=s+'1';
  end;



(*
           Probabilities for
     The Wilcoxon Signed Ranks Test

        cf. W.J.Conover,1971,pp.211-215.
*)


const  Max_n = 30;
       s_count = (Max_n*(Max_n+1)) div 2;

var    My_Pattern : TPattern;


procedure TForm1.OKButtonClick(Sender: TObject);
label P_End;
var   n, i_step, i, T, Max_T : integer;
      Total_T, count, p : real;
      s : string;
begin
      n:=StrToInt(EditN.Text);
      if n > Max_n then
        begin
          ShowMessage('n̒l傫߂܂');
          goto P_End;
        end;

      Max_T:=StrToInt(EditT.Text);

      Total_T:=exp(n*ln(2.0));

      LabelMssg.Caption:='vZł'; UpDate;

      My_Pattern:=TPattern.Create;

      with My_Pattern do
        begin
          init_pattern;
          i_step:=0; count:=0;
          repeat
            if (i_step mod 100000) = 0 then
              begin
                Get_Pattern(s, n);
                EditN.text:=s; UpDate;
              end;

            T:=0;
            for i:=1 to n do
              T:=T+i*Check_Bit(i);
            if T <= Max_T then count:=count+1;

            Next_Pattern; i_step:=i_step+1;
          until Check_end(n);
        end;

      My_Pattern.Free;

      Str( (count/Total_T):8:5, s );
      LabelMssg.caption:='P(t<=T) = ' + s;

      Str(n, s); EditN.Text:=s;

  P_End :
      ExitButton.SetFocus;
end;

end.
