unit UCumBinomial;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label1: TLabel;
    PEdit: TEdit;
    Label2: TLabel;
    NEdit: TEdit;
    Label3: TLabel;
    KEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormActivate(Sender: TObject);
begin
      PEdit.Text:='';
      NEdit.Text:='';
      KEdit.Text:='';
      MsgLabel.Caption:='lݒ肵OK{^NbNĉ';
      PEdit.SetFocus;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;


function MyPower( a, b : Extended ) : Extended;  //  ab
  var  v : extended;
  begin
        if a < 0.0 then
          begin
              ShowMessage('InValid Value for a in MyPower...'
                          +'  a = '+FloatToStrF(a, ffGeneral,18,4));
              Application.Terminate;
          end;

        if a > 0.0 then
          begin
            v:=b*Ln(a);
            if v > -11356.0
              then MyPower:=exp(v)
              else MyPower:=0.0;
          end
        else begin
          if b <> 0 then MyPower:=0.0
                    else MyPower:=1.0;
        end;            
  end;


(*     Prob(x <= k)    *)

function CumBinomial( p    : Extended;
                      n, k : Longint ) : Extended;
  var  v, Combi : Extended;
       i : Longint;
  begin
       v:=0.0;  Combi:=1.0;
       if (k >= 0) and (k <= n) then
         for i:=0 to k do
           begin
             v:=v+Combi*MyPower(p,i)*MyPower(1-p,n-i);
             Combi:=Combi*(n-i)/(i+1);
           end;

       CumBinomial:=v;
  end;   {   CumBinomial   }



(*     Prob( x >= k)     *)

function CumUBinomial( p    : Extended;
                       n, k : Longint ) : Extended;
  var  v, Combi : Extended;
       i : Longint;
  begin
       v:=0.0;  Combi:=1.0;
       if (k >= 0) and (k <= n) then
         for i:=n downto k do
           begin
             v:=v+Combi*MyPower(p,i)*MyPower(1-p,n-i);
             Combi:=Combi*i/(n+1-i);
           end;

       CumUBinomial:=v;
  end;   {   CumUBinomial   }


procedure TForm1.OKButtonClick(Sender: TObject);
var  p, CumToK, CumDowntoK : Extended;
     n, k : Longint;
begin
     MsgLabel.Caption:='vZł'; UpDate;
     p:=StrToFloat(PEdit.Text);
     n:=StrToInt(NEdit.Text);
     k:=StrToInt(KEdit.Text);

     CumToK:=CumBinomial( p, n, k );        //  Prob(x <= k)

     CumDowntoK:=CumUBinomial( p, n, k );   //  Prob( x >= k)

     MsgLabel.Caption:='Prob(x <= k) = '
                       +FloatToStrF(CumToK,ffGeneral,7,4)
                       +' ;    Prob(x >= k) = '
                       +FloatToStrF(CumDowntoK,ffGeneral,7,4);

     ExitButton.SetFocus;
end;

end.
