unit UCheckExpRN;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ExitButton: TButton;
    CheckButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ExitButtonClick(Sender: TObject);
    procedure CheckButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;


(*   ̂߂̃IuWFNg  *)

(*     l    *)
type   TRN    = class
                    a, c, Seed : Longint;

                    //  葱
                    procedure  Init;   virtual;
                    procedure  Init1( s : Longint ); virtual;

                    //   lԂ֐
                    function   Uni : Extended;
                end;


(*   wzɏ]  *)
type   TExpRN = class(TRN)
                       //  wzɏ]Ԃ֐
                       function ERN( Lambda : Extended ) : Extended;
                end;



implementation

{$R *.DFM}

 
(*     葱     *)

procedure  TRN.Init;
  begin
          a    := 69069;
          c    := 1;
          Seed := 1;
  end;

procedure  TRN.Init1( s : Longint );
  begin
          a    := 69069;
          c    := 1;
          Seed := s;
  end;


(*       0.0 < Uni < 1.0     *)

function  TRN.Uni : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        Uni:=(Seed+rn)/rm;
  end;


function TExpRN.ERN( Lambda : Extended ) : Extended;
  var  u : Extended;
  begin
       u:=Uni;
       ERN:=-Ln(u)/Lambda;     //  InversionAiA.3.4.2jɂ
  end;


var  ExpRN : TExpRN;
     ck : (Blue, Green);       //  tH[̐F
     sumb, sumg : Extended;
     Nb, Ng  : Longint;

procedure TForm1.FormCreate(Sender: TObject);
begin
          ExpRN:=TExpRN.Create;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
          ExpRN.Free;
end;



procedure TForm1.ExitButtonClick(Sender: TObject);
begin
        
         Close;
end;



procedure TForm1.CheckButtonClick(Sender: TObject);
var  i : Longint;
     sum : Extended;
begin
     with ExpRN do
       begin
           Init; sum:=0.0;
           for i:=1 to 10000 do sum:=sum+ERN(0.5);
           Canvas.TextOut(10,10,'By Init, Mean = '+
                          FloatToStrF(sum/10000,ffGeneral,9,4));

           Init1(9); sum:=0.0;
           for i:=1 to 10000 do sum:=sum+ERN(0.5);
           Canvas.TextOut(10,50,'By Init(9), Mean = '+
                          FloatToStrF(sum/10000,ffGeneral,9,4));
       end;
end;

end.