unit UGenNormalAdd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;


(*   ̂߂̃IuWFNg  *)

//   l
type   TRN          = class
                          a, c, Seed : Longint;

                          //  葱
                          procedure  Init;   virtual;
                          procedure  Init1( s : Longint ); virtual;

                          //  lԂ֐
                          function   Uni : Extended;
                      end;

//   WKiSɌ藝ɂj
type   TNormalRNAdd = class(TRN)
                          //  WKԂ֐
                          function Normal : Extended;
                      end;



implementation

{$R *.DFM}

 
(*     葱     *)

procedure  TRN.Init;                 //  l͂P
  begin
          a    := 69069;
          c    := 1;
          Seed := 1;
  end;

procedure  TRN.Init1( s : Longint ); //  lsŎw
  begin
          a    := 69069;
          c    := 1;
          Seed := s;
  end;


(*       0.0 < Uni < 1.0     *)

function  TRN.Uni : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        Uni:=(Seed+rn)/rm;
  end;


function TNormalRNAdd.Normal : Extended;
  var v : Extended;
      i : Longint;
  begin
        v:=0.0;
        for i:=1 to 12 do v:=v+Uni;

        Normal:=v-6.0;
  end;


var   NormalRN : TNormalRNAdd;

procedure TForm1.FormCreate(Sender: TObject);
begin
        NormalRN:=TNormalRNAdd.Create;
        NormalRN.Init;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
        NormalRN.Free;
end;


procedure TForm1.OKButtonClick(Sender: TObject);
var   xL, xR, y0, yT, N, i, j, s : Longint;
      c      //  ̒lʓx𐔂z
           : array[-30..30] of Longint;
      MaxD : Extended;

    function PH( v : Extended ) : integer;        //  ẍʒu
      begin
            PH:=Round(0.9*(y0-yT)*v/MaxD);
      end;

    function XPos( v : Extended ) : integer;      //  ẅʒu
      begin
            XPos:=Round(xL+(xR-xL)*(v+3.0)/6.0);
      end;

    function NV( v : Extended ) : Extended;       //  WKz
      begin                                       //  dx=0.1ɑ΂m
            NV:=0.1*exp(-0.5*sqr(v))/sqrt(2*pi);
      end;

begin
     WindowState:=wsMaximized;                //  EBhE̍ő剻
     OKButton.Visible:=False;
     with ExitButton do                       //  Exit{^
       begin  Top:=0; Left:=0; SetFocus;  end;

     UpDate;

     xL:=Round(0.05*ClientWidth);   //  -3.0ɑΉẅʒu
     xR:=Round(0.95*ClientWidth);   //  +3.0ɑΉẅʒu
     yT:=Round(0.05*ClientHeight);  //  x̏[̈ʒu
     y0:=Round(0.95*ClientHeight);  //  x̌_̈ʒu

     with Canvas do
       begin
           //  œhԂ
           Pen.Color:=clWhite;
           Brush.Color:=clWhite;
           Rectangle(0,0,ClientWidth,ClientHeight);

           //  g̕`
           with Pen do
             begin  Width:=2; Color:=clBlack;  end;
           Rectangle(xL, yT, xR, y0);

           for i:=-30 to 30 do c[i]:=0;  //  z̏
           N:=0;                         //  ̗LOɏ
           for i:=1 to 1000000 do
             begin
                 j:=Round(10*NormalRN.Normal);   //  ̐
                 if abs(j) <= 30 then     //  Βl傫߂͖̂
                   begin
                       N:=N+1; c[j]:=c[j]+1;
                   end;

                 if (i mod 10000) = 0 then  //  i̒lExit{^ɕ\
                   begin
                       ExitButton.Caption:=IntToStr(i);
                       UpDate;
                   end;
              end;
            ExitButton.caption:='Exit';  UpDate;

            MaxD:=0.1/sqrt(2*pi);        //  x̃XP[Oɗp

            with Pen do
              begin  Width:=1; Color:=clWhite;  end;
            Brush.Color:=clBlue;
            for i:=-30 to 30 do         //  c[i]̒l̖_Ot
              begin
                  s:=PH(c[i]/N);
                  if s > 0 then
                    Rectangle(xL+Round((i+30)*(xR-xL)/61),   y0-s,
                              xL+Round((i+1+30)*(xR-xL)/61), y0   );
              end;

            //  WKz̃Ot  
            Pen.Color:=clRed;
            MoveTo(xL+Round(0.5*(xR-xL)/61),y0-PH(NV(-3.0)));
            for i:=-29 to 30 do
              LineTo(xL+Round((i+0.5+30)*(xR-xL)/61), y0-PH(NV(i*0.1)));
       end;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
             Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
             OKButton.SetFocus;
end;

end.