unit UGenRN;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    OKButton: TButton;
    ExitButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;


(*   ̂߂̃IuWFNg  *)

(*     l     *)
type   TRN       = class
                       a, c, Seed : Longint;

                       //  葱
                       procedure  Init;   virtual;
                       procedure  Init1( s : Longint ); virtual;

                       //  lԂ֐
                       function   Uni : Extended;
                   end;


(*   WK   *)
type   TNormalRN = class(TRN)
                       //  WKԂ֐
                       function  Normal : Extended;

                       //  Q̓ƗȕWKԂ葱
                       procedure NormalP( var n1, n2 : Extended );
                   end;



implementation

{$R *.DFM}

 
(*     葱     *)

procedure  TRN.Init;                    //  lP
  begin
          a    := 69069;
          c    := 1;
          Seed := 1;
  end;

procedure  TRN.Init1( s : Longint );    //  lsŎw
  begin
          a    := 69069;
          c    := 1;
          Seed := s;
  end;


(*       0.0 < Uni < 1.0     *)

function  TRN.Uni : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        Uni:=(Seed+rn)/rm;
  end;


function TNormalRN.Normal : Extended;
  var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until w < 1.0;

        c:=sqrt(-2.0*Ln(w)/w);

        Normal:=c*v1;
  end;


procedure TNormalRN.NormalP( var n1, n2 : Extended );
  var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until w < 1.0;

        c:=sqrt(-2.0*Ln(w)/w);

        n1:=c*v1;  n2:=c*v2;
  end;


var   NormalRN : TNormalRN;

procedure TForm1.FormCreate(Sender: TObject);
begin
            NormalRN:=TNormalRN.Create;
            NormalRN.Init;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
            NormalRN.Free;
end;

var  ck : boolean;    //  whilȅɗp

procedure TForm1.OKButtonClick(Sender: TObject);
var n1, n2 : Extended;
    x0, xw, y0, yh : integer;
begin
     WindowState:=wsMaximized;       //  EBhE̍ő剻
     OKButton.Visible:=False;
     with ExitButton do              //  Exit{^ɒu
       begin  Top:=0; Left:=0; SetFocus;  end;

     x0:=ClientWidth div 2;          //  w̌_̈ʒu
     xw:=x0 div 3;                   //  W΍̂w̒
     y0:=ClientHeight div 2;         //  x̌_̈ʒu
     yh:=y0 div 3;                   //  W΍̂x̒

     with Canvas do
       begin
           //  œhԂ
           Pen.Color:=clBlack;
           Brush.Color:=clBlack;
           Rectangle(0,0,ClientWidth,ClientHeight);

           ck:=true;
           while ck do   //  Exit{^̃NbNFalseɂȂ
             begin
                 with NormalRN do
                   begin
                    (*   ֐Normal̕gƂ
                       { }p           *)
                    {  repeat
                           n1:=Normal;
                      until  (Abs(n1) < 3.0);
                      repeat
                           n2:=Normal;
                      until  (Abs(n2) < 3.0);   }

                      repeat
                           NormalP( n1, n2 );
                      until  (Abs(n1) < 3.0) and (Abs(n2) < 3.0);

                      Pixels[x0+round(xw*n1), y0+Round(n2*yh)]:=clWhite;
                   end;

                 Application.ProcessMessages;  //  Exit{^̃NbN
                                               //  
             end;
       end;

     Close;    //  vȌI
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            ck:=false;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
             OKButton.SetFocus;
end;

end.