unit UPowerTTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    OKButton: TButton;
    ExitButton: TButton;
    MsgLabel: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    StopButton: TButton;
    OpenDialog1: TOpenDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var   CheckGO : Boolean;
      CheckStart : Boolean = True;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
         StopButton.Visible:=False;
         MsgLabel.Caption:='OK{^NbNĉ';
         if CheckStart
           then       //  ŏ̉ʂ̂Ƃ
             begin
               Edit1.Visible:=False;
               Label2.Visible:=False;
             end
           else
             begin
               Edit1.Visible:=True;
               Label2.Visible:=True;
             end;
         CheckGO:=true;
         OKButton.SetFocus;
end;


type real = extended;
     integer = Longint;

type TFunc = function( x : real ) : real;


(*   f(Root) = c ƂȂlRootbisection@ŋ߂  *)

procedure  Bisection( f : TFunc;
                      s, c, L_b, U_b : real;
                      var  Root : real );
  var  m, v : real;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;   //  AvP[V̏I
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  abs(U_b-L_b) < (1.0E-15)*abs(U_b);

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*   fab܂ł̐ϕKEX̐ϕŋ߂   *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-17;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


(*   Gauss_LegendreɓKIϕ@Kp  *)

procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-17)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-17))
          and
          (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*   CalcIntegralĂяo  *)

function AdaptiveGL( a, b : real;
                     f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }


function My_Power( a, b : real ) : real;
  begin
        My_Power:=exp(b*ln(a));   //  ab
  end;


var  df : integer;


(*   tz̊j   *)

function t_kernel( x : real ) : real;
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df, (df+1)/2);
  end;


function gamma( r : real ) : real;
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;


(*   tz̗ݐϕz֐   *)

function Cum_t_distribution( t : real ) : real;
  var  v : real;
  begin
      if t = 0.0
        then Cum_t_distribution:=0.5
      else if t > 0.0
        then begin
             v:=AdaptiveGL( 0.0, t, t_kernel );
             Cum_t_distribution:=0.5+gamma((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma(df/2));
        end
      else begin
             v:=AdaptiveGL( t, 0.0, t_kernel );
             Cum_t_distribution:=0.5-gamma((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma(df/2));
        end;
  end;



(*   ̂߂̃IuWFNg  *)

(*     l     *)
type   TRN       = class
                       a, c, Seed : Longint;

                       //  葱
                       procedure  Init;   virtual;
                       procedure  Init1( s : Longint ); virtual;

                       //  lԂ֐
                       function   Uni : Extended;
                   end;


(*   WK   *)
type   TNormalRN = class(TRN)
                       //  WKԂ֐
                       function  Normal : Extended;

                       //  Q̓ƗȕWKԂ葱
                       procedure NormalP( var n1, n2 : Extended );
                   end;


 
(*     葱     *)

procedure  TRN.Init;                    //  lP
  begin
          a    := 69069;
          c    := 1;
          Seed := 1;
  end;

procedure  TRN.Init1( s : Longint );    //  lsŎw
  begin
          a    := 69069;
          c    := 1;
          Seed := s;
  end;


(*       0.0 < Uni < 1.0     *)

function  TRN.Uni : Extended;
  const rn = (2.0*$40000000)+1.0;
        rm = (4.0*$40000000)+1.0;
  begin
        Seed:=a*Seed+c;
        Uni:=(Seed+rn)/rm;
  end;


function TNormalRN.Normal : Extended;
  var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until w < 1.0;

        c:=sqrt(-2.0*Ln(w)/w);

        Normal:=c*v1;
  end;


procedure TNormalRN.NormalP( var n1, n2 : Extended );
  var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until w < 1.0;

        c:=sqrt(-2.0*Ln(w)/w);

        n1:=c*v1;  n2:=c*v2;
  end;


var   NormalRN : TNormalRN;
  

(*  meanAW΍sd̐KԂ  *)

function SampleData( mean, sd : real ) : real;
  var  v : real;
  begin
        v:=NormalRN.Normal;
        SampleData:=sd*v+mean;
  end;


type  Vector = array[1..100] of real;

var   d : Vector;


function CalcT( d : Vector;
                n : integer ) : real;
  var i : integer;
      sumd, MeanD, sdd, SD, t : real;
  begin
     sumd:=0.0;
     for i:=1 to n do
       sumd:=sumd+d[i];               //  d[i]=x[i]-y[i]̘a
     MeanD:=sumd/n;                   //  d[i]̕
     sdd:=0.0;
     for i:=1 to n do
       sdd:=sdd+sqr(d[i]-MeanD);      //  d[i]-MeanD̂Qa
     SD:=sqrt(sdd/n);                 //  d[i]̕W΍
     t:=MeanD/(SD/Sqrt(n-1));         //  ťvZ

     CalcT:=t;
  end;   {   CalcT   }




procedure TForm1.OKButtonClick(Sender: TObject);
Label QP, QPZ;
const NExp = 10000;
var  OutFile : TextFile;
     Tc, t, meand : real;
     kn, n, icond, j, count, iexp : integer;
     FNM : string;
begin
     MsgLabel.Caption:='vZn߂܂';
     ExitButton.Visible:=False;
     StopButton.Visible:=True;
     CheckStart:=False;

     with OpenDialog1 do
       begin
           Title:='o͗pt@C';
           if not Execute then
             begin
                MsgLabel.Caption:='LZNbN܂';
                goto QPZ;
             end;
           FNM:=FileName;
       end;

     AssignFile(OutFile, FNM); ReWrite(OutFile);
     for kn:=1 to 3 do
       begin
         case kn of         //   Tvn̐ݒ
               1  : n:=5;
               2  : n:=10;
              else  n:=20;
         end;

         df:=n-1;           //   Rx

         //  P(T <= Tc) = 2.5% ƂȂTc߂
         Bisection( Cum_t_distribution, 1.0, 0.975, 0.0, 10.0, Tc );

         writeln(OutFile);
         writeln(OutFile, 'Tc = ', Tc:7:3, '      LӐ = 5%',
                          '      Rx = ', df);
         writeln(OutFile);
         writeln(OutFile,'count =  abs(t) > Tc ̉');

         for icond:=1 to 5 do
           begin
             MsgLabel.Caption:='icond = '+IntToStr(icond);
             UpDate;

             case icond of            //  ς̍meand̐ݒ
                    1  :  meand:=0.0;
                    2  :  meand:=0.1;
                    3  :  meand:=0.5;
                    4  :  meand:=1.0;
                  else    meand:=2.0;
             end;

             count:=0;

             for iexp:=1 to NExp do   //  NExp̎
               begin
                  if (iexp mod 1000) = 0 then
                    begin
                      MsgLabel.Caption:='iexp = '+IntToStr(iexp)
                                        +'       icond = '+IntToStr(icond)
                                        +'       n = '+IntToStr(n);
                      Update;
                    end;

                  for j:=1 to n do     //  n̃TvO
                       d[j]:=SampleData(meand, 1.0);

                  t:=CalcT(d, n);      //  tľvZ
                  if abs(t) > Tc then count:=count+1;

                  Application.ProcessMessages;   //  Cxg̏
                  if not CheckGO then goto QP;   //  Stop{^NbNꂽ
               end;

             writeln(OutFile);
             writeln(OutFile, 'count = ', count:3,
                              '    NExp = ', NExp,
                              '    MeanX - MeanY = ', meand:5:1,
                              '    TvTCY = ', n);
           end;

         writeln(OutFile); writeln(OutFile);
       end;

 QP :
     CloseFile(OutFile);
     if CheckGO then MsgLabel.Caption:='vZI܂'
                else MsgLabel.Caption:='vZf܂';
 QPZ :
     with Edit1 do begin Text:=FNM; Visible:=True; end;
     Label2.Visible:=True;
     StopButton.Visible:=False;
     ExitButton.Visible:=True;
     ExitButton.SetFocus;
     CheckGO:=True;
end;

procedure TForm1.StopButtonClick(Sender: TObject);
begin
            CheckGO:=False;
end;


(*   ̃IuWFNg̐   *)

procedure TForm1.FormCreate(Sender: TObject);
begin
        NormalRN:=TNormalRN.Create;
        NormalRN.Init;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
        NormalRN.Free;    //  IuWFNg̔p
end;

end.