package clickdraw;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;
import java.awt.*;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameClickDraw extends JFrame {
    JPanel contentPane;
    public FrameClickDraw() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(600,600));
        setTitle("Click ");
        contentPane.addMouseListener(new
                                     FrameClickDraw_contentPane_mouseAdapter(this));
    }


    Graphics g = null;  //  java.awt.*;

    public void contentPane_mouseClicked(MouseEvent e) {
        if (g == null) {
             g = contentPane.getGraphics();
             g.setColor(new Color(255, 255, 255));
             g.fillRect(0, 0, 600, 600);
         } else if (e.getButton() == e.BUTTON1) {
             setTitle("Button1");
             int x = e.getX();
             int y = e.getY();
             int s = (int)(10+50*Math.random());
             int r = (int)(255*Math.random());
             int gr = (int)(255*Math.random());
             int b = (int)(255*Math.random());
             g.setColor(new Color(r,gr,b));
             g.fillOval(x-s,y-s,2*s,2*s);
         } else if (e.getButton() == e.BUTTON2) {
             setTitle("Button2");
             int r = (int)(255*Math.random());
             int gr = (int)(255*Math.random());
             int b = (int)(255*Math.random());
             g.setColor(new Color(r,gr,b));
             g.fillRect(0,0,600,600);

         } else if (e.getButton() == e.BUTTON3) {
             setTitle("Button3");
             int x = e.getX();
             int y = e.getY();
             int s = (int)(10+50*Math.random());
             int r = (int)(255*Math.random());
             int gr = (int)(255*Math.random());
             int b = (int)(255*Math.random());
             g.setColor(new Color(r,gr,b));
             g.fillRect(x-s,y-s,2*s,2*s);

         } else {
             setTitle("ButtonX");
        }
    }
}


class FrameClickDraw_contentPane_mouseAdapter extends MouseAdapter {
    private FrameClickDraw adaptee;
    FrameClickDraw_contentPane_mouseAdapter(FrameClickDraw adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseClicked(MouseEvent e) {
        adaptee.contentPane_mouseClicked(e);
    }
}
