package ckmydialog;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import pkgmydialog.*;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.*;

/**
 * <p>Title: Check My Dialog</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameCkMyDialog extends JFrame {
    JPanel contentPane;
    JButton jButtonExit = new JButton();
    JButton jButtonOK = new JButton();
    JLabel jLabel1 = new JLabel();
    JButton jButton1OKMsg = new JButton();
    JButton jButtonOKLT = new JButton();
    public FrameCkMyDialog() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 300));
        setTitle("Check my Dialog");
        jButtonExit.setBounds(new Rectangle(236, 156, 71, 23));
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new
                                      FrameCkMyDialog_jButtonExit_actionAdapter(this));
        jButtonOK.setBounds(new Rectangle(69, 122, 71, 23));
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new FrameCkMyDialog_jButtonOK_actionAdapter(this));
        jLabel1.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel1.setText("jLabel1");
        jLabel1.setBounds(new Rectangle(39, 57, 323, 30));
        jButton1OKMsg.setBounds(new Rectangle(69, 160, 88, 23));
        jButton1OKMsg.setText("OK (Msg)");
        jButton1OKMsg.addActionListener(new
                FrameCkMyDialog_jButton1OKMsg_actionAdapter(this));
        jButtonOKLT.setBounds(new Rectangle(69, 201, 126, 23));
        jButtonOKLT.setText("OK (Msg, Text)");
        jButtonOKLT.addActionListener(new
                                      FrameCkMyDialog_jButtonOKLT_actionAdapter(this));
        contentPane.add(jButtonOK, null);
        contentPane.add(jButton1OKMsg, null);
        contentPane.add(jButtonOKLT, null);
        contentPane.add(jButtonExit, null);
        contentPane.add(jLabel1, null);
    }

    public void jButtonExit_actionPerformed(ActionEvent e) {
               System.exit(0);
    }

    public void jButtonOK_actionPerformed(ActionEvent e) {
        myDialog d = new myDialog();
        d.show();

        jLabel1.setText("Text = <"+d.getText()+'>');

        d.dispose();
    }

    public void jButton1OKMsg_actionPerformed(ActionEvent e) {
        myDialog d = new myDialog();
        d.show("Set your text");

        jLabel1.setText("Text = <"+d.getText()+'>');

        d.dispose();
    }

    public void jButtonOKLT_actionPerformed(ActionEvent e) {
        myDialog d = new myDialog();
        d.show("Set your Text", "write your text here");

        jLabel1.setText("Text = <"+d.getText()+'>');

        d.dispose();
    }
}


class FrameCkMyDialog_jButtonOKLT_actionAdapter implements ActionListener {
    private FrameCkMyDialog adaptee;
    FrameCkMyDialog_jButtonOKLT_actionAdapter(FrameCkMyDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonOKLT_actionPerformed(e);
    }
}


class FrameCkMyDialog_jButtonOK_actionAdapter implements ActionListener {
    private FrameCkMyDialog adaptee;
    FrameCkMyDialog_jButtonOK_actionAdapter(FrameCkMyDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonOK_actionPerformed(e);
    }
}


class FrameCkMyDialog_jButton1OKMsg_actionAdapter implements ActionListener {
    private FrameCkMyDialog adaptee;
    FrameCkMyDialog_jButton1OKMsg_actionAdapter(FrameCkMyDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton1OKMsg_actionPerformed(e);
    }
}


class FrameCkMyDialog_jButtonExit_actionAdapter implements ActionListener {
    private FrameCkMyDialog adaptee;
    FrameCkMyDialog_jButtonExit_actionAdapter(FrameCkMyDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExit_actionPerformed(e);
    }
}
