package demomydialog;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;

import pkgmydialog.*;
import javax.swing.JButton;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.GridBagLayout;
import java.awt.*;

/**
 * <p>Title: Demonstration of my dialog</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameDemoMyDialog extends JFrame {
    JPanel contentPane;
    JButton jButtonExit = new JButton();
    JButton jButtonGO = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    public FrameDemoMyDialog() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(gridBagLayout1);
        setSize(new Dimension(400, 300));
        setTitle("Using My Dialog");
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new
                FrameDemoMyDialog_jButtonExit_actionAdapter(this));
        jButtonGO.setText("GO");
        jButtonGO.addActionListener(new
                                    FrameDemoMyDialog_jButtonGO_actionAdapter(this));
        contentPane.add(jButtonExit,
                        new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
                                               , GridBagConstraints.CENTER,
                                               GridBagConstraints.NONE,
                                               new Insets(132, 78, 143, 100),
                                               22, 0));
        contentPane.add(jButtonGO, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.CENTER, GridBagConstraints.NONE,
                new Insets(132, 80, 143, 0), 22, 0));
    }

    public void jButtonExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void jButtonGO_actionPerformed(ActionEvent e) {
        myDialog d = new myDialog();
        d.show("a =");
        int a = Integer.parseInt(d.getText());

        d.show("b =");
        int b = Integer.parseInt(d.getText());

        d.show("a = "+a+"  b = "+b, " a + b = "+(a+b));

        d.dispose();
    }
}


class FrameDemoMyDialog_jButtonGO_actionAdapter implements ActionListener {
    private FrameDemoMyDialog adaptee;
    FrameDemoMyDialog_jButtonGO_actionAdapter(FrameDemoMyDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonGO_actionPerformed(e);
    }
}


class FrameDemoMyDialog_jButtonExit_actionAdapter implements ActionListener {
    private FrameDemoMyDialog adaptee;
    FrameDemoMyDialog_jButtonExit_actionAdapter(FrameDemoMyDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExit_actionPerformed(e);
    }
}
