package ckdiamond;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.awt.*;     //   new Color(int,int,int)p

/**
 * <p>Title: Draw diamond patterns</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameCkDiamond extends JFrame {
    JPanel contentPane;
    JLabel jLabel1 = new JLabel();
    JTextField jTextField1 = new JTextField();
    JButton jButtonDraw = new JButton();
    JButton jButtonExit = new JButton();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    public FrameCkDiamond() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(gridBagLayout1);

        /*    t[TCY̐ݒ   */
        setSize(new Dimension(650, 670));
        setTitle("Diamond Pattern");
        jLabel1.setFont(new java.awt.Font("Dialog", Font.PLAIN, 16));
        jLabel1.setText("N = ");
        jTextField1.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jTextField1.setText("20");
        jButtonDraw.setText("Draw");
        jButtonDraw.addActionListener(new
                                      FrameCkDiamond_jButtonDraw_actionAdapter(this));
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new
                                      FrameCkDiamond_jButtonExit_actionAdapter(this));
        contentPane.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE,
                new Insets(5, 31, 0, 0), 6, -6));
        contentPane.add(jTextField1,
                        new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
                                               , GridBagConstraints.WEST,
                                               GridBagConstraints.HORIZONTAL,
                                               new Insets(5, 0, 0, 0), 39, -4));
        contentPane.add(jButtonDraw,
                        new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
                                               , GridBagConstraints.CENTER,
                                               GridBagConstraints.NONE,
                                               new Insets(5, 24, 0, 0), 12, 0));
        contentPane.add(jButtonExit,
                        new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
                                               , GridBagConstraints.CENTER,
                                               GridBagConstraints.NONE,
                                               new Insets(5, 333, 0, 20), 22, 0));
        contentPane.add(jPanel1, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0
                , GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(23, 10, 15, 10), 620, 598));
        contentPane.setBackground(new Color(255,220,220));  //  t[̐F̐ݒ

        jPanel1.setBackground(new Color(255,220,220));      //  pl̐F̐ݒ

    }

    public void jButtonExit_actionPerformed(ActionEvent e) {
                  System.exit(1);
    }

    public void jButtonDraw_actionPerformed(ActionEvent e) {

        int n = Integer.parseInt(jTextField1.getText());

        if (n < 5) n = 5;

        //  _̍Wlp̔z
        double posx[] = new double[n];
        double posy[] = new double[n];

        //   (x0,y0): pl̒S
        int x0 = jPanel1.getWidth() / 2;
        int y0 = jPanel1.getHeight() / 2;

        //  r: _CAhp^[̔a
        int r  = (int)(x0*0.9);

        //   _(posx[i], posy[i])̐ݒ
        for (int i = 0; i < n; i++) {
            posx[i] = x0 + r*Math.cos(Math.toRadians(90+i*360.0/n));
            posy[i] = y0 - r*Math.sin(Math.toRadians(90+i*360.0/n));
        }


        Graphics  g = jPanel1.getGraphics();

        //  plŜ̓hԂ
        g.setColor(new Color(255,220,220));
        g.fillRect(0,0,jPanel1.getWidth(),jPanel1.getHeight());

        g.setColor( new Color(0,0,255));

        //   _CAhEp^[̍쐬
        //   _ԂŌ
        for (int i = 0; i < n; i++) {
          for (int j = 0; j < n; j++) {
              g.drawLine((int)posx[i], (int)posy[i],
                         (int)posx[j], (int)posy[j] );
          }
        }

    }


}


class FrameCkDiamond_jButtonDraw_actionAdapter implements ActionListener {
    private FrameCkDiamond adaptee;
    FrameCkDiamond_jButtonDraw_actionAdapter(FrameCkDiamond adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonDraw_actionPerformed(e);
    }
}


class FrameCkDiamond_jButtonExit_actionAdapter implements ActionListener {
    private FrameCkDiamond adaptee;
    FrameCkDiamond_jButtonExit_actionAdapter(FrameCkDiamond adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExit_actionPerformed(e);
    }
}
