package mandelbrot;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.awt.*;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameMandelbrot extends JFrame {
    JPanel contentPane;
    JButton jButton1 = new JButton();
    JPanel jPanel1 = new JPanel();
    JTextField jTextFieldMinX = new JTextField();
    JLabel jLabel1 = new JLabel();
    JTextField jTextFieldMaxX = new JTextField();
    JTextField jTextFieldMinY = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField jTextFieldMaxY = new JTextField();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    public FrameMandelbrot() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(530,600));
        setTitle("Mandelbrot Set");
        jButton1.setBounds(new Rectangle(6, 1, 71, 23));
        jButton1.setText("Draw");
        jButton1.addActionListener(new FrameMandelbrot_jButton1_actionAdapter(this));
        jPanel1.setBounds(new Rectangle(12,40,500,500));
        jTextFieldMinX.setText("-0.220");
        jTextFieldMinX.setBounds(new Rectangle(162, 2, 60, 20));
        jLabel1.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel1.setToolTipText("");
        jLabel1.setText("");
        jLabel1.setBounds(new Rectangle(124, 5, 34, 15));
        jTextFieldMaxX.setText("-0.205");
        jTextFieldMaxX.setBounds(new Rectangle(242, 2, 56, 20));
        jTextFieldMinY.setText("0.680");
        jTextFieldMinY.setBounds(new Rectangle(372, 4, 49, 20));
        jLabel2.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel2.setText("");
        jLabel2.setBounds(new Rectangle(338, 5, 34, 15));
        jTextFieldMaxY.setText("0.693");
        jTextFieldMaxY.setBounds(new Rectangle(445, 4, 48, 20));
        jLabel3.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel3.setText("`");
        jLabel3.setBounds(new Rectangle(223, 2, 19, 21));
        jLabel4.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel4.setText("`");
        jLabel4.setBounds(new Rectangle(423, 4, 19, 22));
        contentPane.add(jPanel1);
        contentPane.add(jButton1);
        contentPane.add(jTextFieldMaxY);
        contentPane.add(jLabel4);
        contentPane.add(jTextFieldMinY);
        contentPane.add(jLabel2);
        contentPane.add(jTextFieldMaxX);
        contentPane.add(jLabel3);
        contentPane.add(jTextFieldMinX);
        contentPane.add(jLabel1);
    }

   //   fƂ̉Ẑ߂̃NX^
    class cmplx {
        double rp, ip;

        cmplx ( double r, double i ) {
                  rp = r;  ip = i;
        }

        cmplx () {
            this(0.0, 0.0);
        }

        cmplx add( cmplx a ) {
                double r, i;
                r = rp + a.rp;
                i = ip + a.ip;
                return new cmplx(r,i);
        }

        cmplx sqr() {
            double r, i;
            r = rp*rp - ip*ip;
            i = 2*rp*ip;
            return new cmplx(r,i);
        }

        double abs() {
             double v;
             v = Math.sqrt(rp*rp + ip*ip);
             return v;
        }
    }

    public void jButton1_actionPerformed(ActionEvent e) {
        Graphics g = jPanel1.getGraphics();

        double minr = Double.parseDouble(jTextFieldMinX.getText());
        double maxr = Double.parseDouble(jTextFieldMaxX.getText());
        double mini = Double.parseDouble(jTextFieldMinY.getText());
        double maxi = Double.parseDouble(jTextFieldMaxY.getText());
        cmplx c, z;
        for (int ix = 0; ix < 500; ix++) {
            for (int iy = 0; iy < 500; iy++) {
                c = new cmplx(minr + (maxr-minr)*ix/499,
                              mini + (maxi-mini)*iy/499);
                z = new cmplx(0.0,0.0);
                int n = 0;
                do {
                    z = z.sqr().add(c);
                    n++;
                } while ((z.abs() <= 2.0) && (n <= 100));

                n = (int) (n*n*6.0/10001);
                switch (n) {
                    case 0:   g.setColor(new Color(255,255,255));
                              break;
                    case 1:   g.setColor(new Color(0,255,0));
                              break;
                    case 2:   g.setColor(new Color(0,0,255));
                              break;
                    case 3:   g.setColor(new Color(255,255,0));
                              break;
                    case 4:   g.setColor(new Color(255,0,255));
                              break;
                    case 5:   g.setColor(new Color(0,255,255));
                              break;
                    default:  g.setColor(new Color(0,0,0));
                }
                g.fillRect(ix,499-iy,1,1);
            }
        }
    }
}


class FrameMandelbrot_jButton1_actionAdapter implements ActionListener {
    private FrameMandelbrot adaptee;
    FrameMandelbrot_jButton1_actionAdapter(FrameMandelbrot adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton1_actionPerformed(e);
    }
}
