package ckformat;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import java.awt.Rectangle;
import java.awt.Font;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * <p>Title: Check Format</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameCkFormat extends JFrame {
    JPanel contentPane;
    JLabel jLabel1 = new JLabel();
    JTextField jTextFieldA = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField jTextFieldB = new JTextField();
    JLabel jLabelAB = new JLabel();
    JButton jButtonP = new JButton();
    JButton jButtonE = new JButton();
    JButton jButtonExit = new JButton();
    JButton jButtonF = new JButton();
    public FrameCkFormat() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 270));  //  t[TCY̐ݒ
        setTitle("Check Format");
        jLabel1.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel1.setText("a = ");
        jLabel1.setBounds(new Rectangle(76, 40, 24, 15));
        jTextFieldA.setBounds(new Rectangle(100, 41, 62, 20));
        jLabel2.setFont(new java.awt.Font("Dialog", Font.PLAIN, 14));
        jLabel2.setText("b = ");
        jLabel2.setBounds(new Rectangle(197, 43, 26, 15));
        jTextFieldB.setBounds(new Rectangle(221, 43, 62, 20));
        jLabelAB.setFont(new java.awt.Font("Dialog", Font.PLAIN, 16));
        jLabelAB.setText("a/b = ");
        jLabelAB.setBounds(new Rectangle(63, 82, 284, 24));
        jButtonP.setBounds(new Rectangle(154, 139, 71, 23));
        jButtonP.setText("###.##");
        jButtonP.addActionListener(new FrameCkFormat_jButtonP_actionAdapter(this));
        jButtonE.setBounds(new Rectangle(264, 139, 97, 23));
        jButtonE.setText("#.###E##");
        jButtonE.addActionListener(new FrameCkFormat_jButtonE_actionAdapter(this));
        jButtonExit.setBounds(new Rectangle(155, 188, 71, 23));
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new
                                      FrameCkFormat_jButtonExit_actionAdapter(this));
        jButtonF.setBounds(new Rectangle(38, 140, 71, 23));
        jButtonF.setText("Free");
        jButtonF.addActionListener(new FrameCkFormat_jButtonF_actionAdapter(this));
        contentPane.add(jLabel1);
        contentPane.add(jTextFieldA);
        contentPane.add(jLabel2);
        contentPane.add(jTextFieldB);
        contentPane.add(jLabelAB);
        contentPane.add(jButtonExit);
        contentPane.add(jButtonE);
        contentPane.add(jButtonP);
        contentPane.add(jButtonF);
    }

    public void jButtonExit_actionPerformed(ActionEvent e) {
        System.exit(1);
    }

    public void jButtonP_actionPerformed(ActionEvent e) {
        double a, b;
        String s = "";

        java.text.DecimalFormat
            df = new java.text.DecimalFormat("0.00000");

        a = Double.parseDouble(jTextFieldA.getText());
        b = Double.parseDouble(jTextFieldB.getText());
        s = df.format(a/b);

        jLabelAB.setText("a/b = "+s);
    }

    public void jButtonF_actionPerformed(ActionEvent e) {
         double a, b;
         String s = "";

         a = Double.parseDouble(jTextFieldA.getText());
         b = Double.parseDouble(jTextFieldB.getText());

         s = "a/b = " + (a/b);

        jLabelAB.setText(s);
    }

    public void jButtonE_actionPerformed(ActionEvent e) {
        double a, b;
        String s = "";

        java.text.DecimalFormat
            df = new java.text.DecimalFormat("0.00000E000");

        a = Double.parseDouble(jTextFieldA.getText());
        b = Double.parseDouble(jTextFieldB.getText());
        s = df.format(a/b);

        jLabelAB.setText("a/b = "+s);
    }
}


class FrameCkFormat_jButtonE_actionAdapter implements ActionListener {
    private FrameCkFormat adaptee;
    FrameCkFormat_jButtonE_actionAdapter(FrameCkFormat adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonE_actionPerformed(e);
    }
}


class FrameCkFormat_jButtonF_actionAdapter implements ActionListener {
    private FrameCkFormat adaptee;
    FrameCkFormat_jButtonF_actionAdapter(FrameCkFormat adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonF_actionPerformed(e);
    }
}


class FrameCkFormat_jButtonP_actionAdapter implements ActionListener {
    private FrameCkFormat adaptee;
    FrameCkFormat_jButtonP_actionAdapter(FrameCkFormat adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonP_actionPerformed(e);
    }
}


class FrameCkFormat_jButtonExit_actionAdapter implements ActionListener {
    private FrameCkFormat adaptee;
    FrameCkFormat_jButtonExit_actionAdapter(FrameCkFormat adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExit_actionPerformed(e);
    }
}
