package stat1v;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.FileDialog;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.FileReader;
import java.io.BufferedWriter;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameStat1V extends JFrame {
    JPanel contentPane;
    JButton jButton1 = new JButton();
    public FrameStat1V() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 300));
        setTitle("Pϗʓv");
        jButton1.setBounds(new Rectangle(160, 126, 71, 23));
        jButton1.setText("GO");
        jButton1.addActionListener(new FrameStat1V_jButton1_actionAdapter(this));
        contentPane.add(jButton1);
    }



    double x[] = new double[1000];

    public void jButton1_actionPerformed(ActionEvent e) {
         FileDialog fdlogLoad = new FileDialog(this, "Input File Name",
                                              FileDialog.LOAD);
         fdlogLoad.show();

         FileDialog fdlogSave = new FileDialog(this, "Output File Name",
                                               FileDialog.SAVE);
         fdlogSave.show();

         String ss;

         try {
             BufferedReader fin = new BufferedReader(
                                          new FileReader(
                                                  fdlogLoad.getDirectory()+
                                                  fdlogLoad.getFile()
                                          )
                                  );

             PrintWriter fout = new PrintWriter(
                                    new BufferedWriter(
                                        new FileWriter(
                                                fdlogSave.getDirectory()+
                                                fdlogSave.getFile()
                                        )
                                    )
                                );

             while ((ss = fin.readLine()) != null) {
                     if (ss.length() > 0) {
                            if (ss.charAt(0) == '/') break;
                     }
             }
             if (ss == null) {
                 fin.close();
                 fout.println('\n'+"Abnormal end of the file");
                 fout.close();
                 System.out.println('\n'+"Abnormal end of the file");
                 System.exit(9);
             }

             double v;
             double sum = 0.0;
             int n = 0;
             while ((ss = fin.readLine()) != null) {
                        if (ss.charAt(0) == '/') break;
                        v = Double.parseDouble(ss);
                        n++;
                        x[n] = v;
             }
             fin.close();

             fout.println("̓f[^");
             for (int i = 1; i <= n; i++) {
                    fout.println("x["+i+"] = "+x[i]);
                    sum += x[i];
             }
             double mean = sum/n;

             double sum2 = 0.0;
             double sum3 = 0.0;
             double sum4 = 0.0;
             for (int i=1; i <= n; i++) {
                 sum2 += (x[i]-mean)*(x[i]-mean);
                 sum3 += (x[i]-mean)*(x[i]-mean)*(x[i]-mean);
                 sum4 += (x[i]-mean)*(x[i]-mean)*(x[i]-mean)*(x[i]-mean);
             }
             double s2 = sum2/n;
             double sd = Math.sqrt(s2);
             double sp2 = sum2/(n-1);
             double g1 = sum3/(sd*sd*sd*n);
             double g2 = sum4/(sd*sd*sd*sd*n);

             java.text.DecimalFormat df = new java.text.DecimalFormat("0.000");

             fout.println('\n'+"ϒl = "+df.format(mean));
             fout.println("W΍ = "+df.format(sd));
             fout.println("U = "+df.format(s2));
             fout.println("sΕU = "+df.format(sp2));
             fout.println("cx = "+df.format(g1));
             fout.println("x = "+df.format(g2));
             fout.println("x-3 = "+df.format(g2-3));

             sort.cSort.quickSort(x, n);

             double maxX = x[n];
             double minX = x[1];
             double median;
             if ((n % 2) == 1) {
                   median = x[n/2 + 1];
             } else {
                   median = (x[n/2]+x[n/2+1])/2;
             }

             int ii = (int)(0.5 + ((double)n)/4.0);
             double w1 = 0.5 + ((double)n)/4.0 - ii;
             double w2 = 1.0-w1;
             double q1 = w2*x[ii] + w1*x[ii+1];

             ii = (int)(0.5 + 3.0*((double)n)/4.0);
             w1 = 0.5 + 3.0*((double)n)/4.0 - ii;
             w2 = 1.0-w1;
             double q3 = w2*x[ii] + w1*x[ii+1];


             fout.println('\n'+"\[g̃f[^̏");
             for (int i = 1; i <= n; i++) {
                      fout.println("x["+i+"] = "+x[i]);
             }
             fout.println();
             fout.println("ŏl = "+minX);
             fout.println("Q1    = "+df.format(q1));
             fout.println("l = "+df.format(median));
             fout.println("Q3    = "+df.format(q3));
             fout.println("ől = "+maxX);
             fout.println("lʕ΍ = "+df.format((q3-q1)/2));

             fout.close();
         }
         catch (Exception e1) {
             System.out.println('\n'+"Err(9)"+e1);
             System.exit(9);
         }

         System.exit(0);
    }
}


class FrameStat1V_jButton1_actionAdapter implements ActionListener {
    private FrameStat1V adaptee;
    FrameStat1V_jButton1_actionAdapter(FrameStat1V adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton1_actionPerformed(e);
    }
}
