package stat2v;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.FileDialog;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.FileReader;
import java.io.BufferedWriter;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameStat2V extends JFrame {
    JPanel contentPane;
    JButton jButton1 = new JButton();
    public FrameStat2V() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 300));
        setTitle("Qϗʓv");
        jButton1.setBounds(new Rectangle(163, 130, 71, 23));
        jButton1.setText("GO");
        jButton1.addActionListener(new FrameStat2V_jButton1_actionAdapter(this));
        contentPane.add(jButton1);
    }


    //   PԖڂ̃f[^̒o
    String seekFirst( String ss ) {
        int p0 = 0;
        while (ss.charAt(p0) == ' ') p0++;
        int p1 = ss.indexOf(' ',p0);

        return ss.substring(p0,p1);
    }

    //   QԖڂ̃f[^̒o
    String seekSecond( String ss ) {
        int p0 = 0;
        while (ss.charAt(p0) == ' ') p0++;
        do {
            p0++;
        } while (ss.charAt(p0) != ' ');
        int p1 = ss.length();

        return ss.substring(p0,p1);
    }

    double[] x = new double[100];
    double[] y = new double[100];

    public void jButton1_actionPerformed(ActionEvent e) {
          //    ̓f[^t@C̎擾
          FileDialog fdlogLoad = new FileDialog(this, "Input File Name",
                                               FileDialog.LOAD);
          fdlogLoad.show();

          //    o̓f[^t@C̐ݒ
          FileDialog fdlogSave = new FileDialog(this, "Output File Name",
                                                FileDialog.SAVE);
          fdlogSave.show();

          String ss;

          try {
              //   ͗pCX^Xfin̐ݒ
              BufferedReader fin = new BufferedReader(
                                           new FileReader(
                                                   fdlogLoad.getDirectory()+
                                                   fdlogLoad.getFile()
                                           )
                                   );

              //   o͗pCX^Xfout̐ݒ
              PrintWriter fout = new PrintWriter(
                                     new BufferedWriter(
                                         new FileWriter(
                                                 fdlogSave.getDirectory()+
                                                 fdlogSave.getFile()
                                         )
                                     )
                                 );

              //    XbV/Ŏn܂s܂Ői
              while ((ss = fin.readLine()) != null) {
                      if (ss.length() > 0) {
                             if (ss.charAt(0) == '/') break;
                      }
              }
              if (ss == null) {
                  System.out.println('\n'+"Abnormal end of the file");
                  System.exit(9);
              }

              double v;
              double sum = 0.0;
              int n = 0;
              while ((ss = fin.readLine()) != null) {
                         if (ss.charAt(0) == '/') break;  //  f[^s̏I
                         v = Double.parseDouble(seekFirst(ss));
                         n++;
                         x[n] = v;
                         v = Double.parseDouble(seekSecond(ss));
                         y[n] = v;
              }
              fin.close();

              double sumX = 0.0;
              double sumY = 0.0;
              for (int i = 1; i <= n; i++) {
                     fout.println("x["+i+"] = "+x[i]+
                                  "    y["+i+"] = "+y[i]);
                     sumX += x[i];
                     sumY += y[i];
              }
              double meanX = sumX/n;
              double meanY = sumY/n;

              double sumXX = 0.0;
              double sumYY = 0.0;
              double sumXY = 0.0;
              for (int i=1; i <= n; i++) {
                       sumXX += (x[i]-meanX)*(x[i]-meanX);
                       sumYY += (y[i]-meanY)*(y[i]-meanY);
                       sumXY += (x[i]-meanX)*(y[i]-meanY);
              }
              double vX = sumXX/n;          //   U
              double sdX = Math.sqrt(vX);
              double ubvX = sumXX/(n-1);    //   sΕU
              double vY = sumYY/n;
              double sdY = Math.sqrt(vY);
              double ubvY = sumYY/(n-1);
              double cov = sumXY/n;
              double r = cov/(sdX*sdY);

              java.text.DecimalFormat df = new java.text.DecimalFormat("0.000");

              fout.println();
              fout.println("w̓v");
              fout.println("         = "+df.format(meanX));
              fout.println("    U     = "+df.format(vX));
              fout.println("    W΍ = "+df.format(sdX));
              fout.println("    sΕU = "+df.format(ubvX));
              fout.println();
              fout.println("x̓v");
              fout.println("         = "+df.format(meanY));
              fout.println("    U     = "+df.format(vY));
              fout.println("    W΍ = "+df.format(sdY));
              fout.println("    sΕU = "+df.format(ubvY));
              fout.println();
              fout.println("U   = "+df.format(cov));
              fout.println("֌W = "+df.format(r));

              fout.close();
          }
          catch (Exception e1) {
              System.out.println('\n'+"Err(9)"+e1);
              System.exit(9);
          }

         System.exit(0);
    }
}


class FrameStat2V_jButton1_actionAdapter implements ActionListener {
    private FrameStat2V adaptee;
    FrameStat2V_jButton1_actionAdapter(FrameStat2V adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton1_actionPerformed(e);
    }
}
