package cktxtrdwr;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JEditorPane;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Color;
import java.awt.ScrollPane;
import java.awt.TextArea;

import java.awt.*;
import java.io.*;

/**
 * <p>Title: Check Text Read/Write</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameCkTxtRdWr extends JFrame {
    JPanel contentPane;
    JButton jButtonExit = new JButton();
    JButton jButtonGO = new JButton();
    public FrameCkTxtRdWr() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 300));
        setTitle("Text Read/Write");
        jButtonExit.setBounds(new Rectangle(251, 136, 71, 23));
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new
                                      FrameCkTxtRdWr_jButtonExit_actionAdapter(this));
        jButtonGO.setBounds(new Rectangle(88, 137, 71, 23));
        jButtonGO.setText("GO");
        jButtonGO.addActionListener(new FrameCkTxtRdWr_jButtonGO_actionAdapter(this));
        contentPane.add(jButtonGO);
        contentPane.add(jButtonExit);
    }

    public void jButtonExit_actionPerformed(ActionEvent e) {
                    System.exit(1);
    }

    public void jButtonGO_actionPerformed(ActionEvent e) {
        FileDialog finName = new FileDialog( this, "Input File Name", FileDialog.LOAD);
        finName.show();
        FileDialog foutName = new FileDialog( this, "Output File Name", FileDialog.SAVE);
        foutName.show();

        try {
            BufferedReader fin = new BufferedReader (
                                   new FileReader ( finName.getDirectory()
                                                    + finName.getFile() )
                                 );
            PrintWriter fout = new PrintWriter(
                                 new BufferedWriter(
                                   new FileWriter( foutName.getDirectory()
                                                      + foutName.getFile() )
                                 )
                               );

            String ss = "";
            boolean ck = true;
            do {
                ss=fin.readLine();
                //  s̐擪/Ŏn܂邩ǂ̃`FbN
                if (ss.length() > 0) {
                    if (ss.charAt(0) == '/')  ck = false;
                }
            } while (ck);

           int x, y, z;
           String s1, s2;
           MyStrMngr fstr = new MyStrMngr();
           ck = true;
           do {
               ss = fin.readLine();
               if (ss.charAt(0) == '/') {
                   ck = false;   //  s̐擪/łΓǂݍݏI
               }
               else {
                   x = Integer.parseInt(fstr.subStrExtr( ss, 0 ));
                   y = Integer.parseInt(fstr.subStrExtr( ss, 1 ));
                   z = Integer.parseInt(fstr.subStrExtr( ss, 2 ));
                   fout.println("   x = "+x+"   y = "+y+"   z = "+z);
               }
           } while (ck);

            fin.close();

            fout.close();
        }
        catch (Exception e1) {
            System.out.println("err: "+e1);
        }

        System.exit(0);
    }
}


class  MyStrMngr {

    int seekNBlnk ( String str, int a ) {
        int v = -9;

        if ((a+1) > str.length()) {
            v = -9;
        }
        else {
            boolean ck = true;
            while (ck) {
                if (str.charAt(a) != ' ') {
                    v = a;
                    ck = false;
                } else {
                    if ((a + 1) >= str.length()) {
                        v = -9;
                        ck = false;
                    } else {
                        a++;
                    }
                }
            }
        }

        return v;
    }

    int seekBlnk ( String str, int b ) {
        int v = -9;

        if ((b+1) > str.length()) {
            v = -9;
        }
        else {
            v = str.indexOf(' ', b);
            if (v < 0) v = -9;
        }

        return v;
    }

    String subStrExtr ( String str, int n ) {
        String s = "";
        int start = 0;
        int end = -9;

        n++;

        if ((str.length() > 0) && (n >= 1)) {
            end = 0;
            for (int i=1; i<=n; i++) {
                if (end >= 0) {
                    start = seekNBlnk(str, end );
                    if (start >= 0) {
                        end = seekBlnk( str, start );
                        if (end < 0) end=str.length();
                    }
                    else {
                        end = -9;
                    }

                }
            }
        }

        if (end > -9) s = str.substring(start, end );

        return s;
    }
}


class FrameCkTxtRdWr_jButtonGO_actionAdapter implements ActionListener {
    private FrameCkTxtRdWr adaptee;
    FrameCkTxtRdWr_jButtonGO_actionAdapter(FrameCkTxtRdWr adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonGO_actionPerformed(e);
    }
}


class FrameCkTxtRdWr_jButtonExit_actionAdapter implements ActionListener {
    private FrameCkTxtRdWr adaptee;
    FrameCkTxtRdWr_jButtonExit_actionAdapter(FrameCkTxtRdWr adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExit_actionPerformed(e);
    }
}
